/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.servlet;

import com.liferay.portal.kernel.io.WriterOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;

public class PipingServletResponse
extends HttpServletResponseWrapper {
    private static final Log _log = LogFactoryUtil.getLog(PipingServletResponse.class);
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;

    public PipingServletResponse(HttpServletResponse response, OutputStream outputStream) {
        super(response);
        if (outputStream == null) {
            throw new NullPointerException("Output stream is null");
        }
        this._servletOutputStream = new ServletOutputStreamAdapter(outputStream);
    }

    public PipingServletResponse(HttpServletResponse response, PrintWriter printWriter) {
        super(response);
        if (printWriter == null) {
            throw new NullPointerException("Print writer is null");
        }
        this._printWriter = printWriter;
    }

    public PipingServletResponse(HttpServletResponse response, ServletOutputStream servletOutputStream) {
        super(response);
        if (servletOutputStream == null) {
            throw new NullPointerException("Servlet output stream is null");
        }
        this._servletOutputStream = servletOutputStream;
    }

    public PipingServletResponse(HttpServletResponse response, Writer writer) {
        super(response);
        if (writer == null) {
            throw new NullPointerException("Writer is null");
        }
        this._printWriter = UnsyncPrintWriterPool.borrow((Writer)writer);
    }

    public PipingServletResponse(PageContext pageContext) {
        this((HttpServletResponse)pageContext.getResponse(), (Writer)pageContext.getOut());
    }

    public ServletOutputStream getOutputStream() {
        if (this._servletOutputStream == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Getting an output stream when a writer is available is not recommended because it is slow");
            }
            this._servletOutputStream = new ServletOutputStreamAdapter((OutputStream)new WriterOutputStream((Writer)this._printWriter, this.getCharacterEncoding(), this.getBufferSize(), true));
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._printWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Getting a writer when an output stream is available is not recommended because it is slow");
            }
            this._printWriter = UnsyncPrintWriterPool.borrow((OutputStream)this._servletOutputStream, (String)this.getCharacterEncoding());
        }
        return this._printWriter;
    }
}

