/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.search;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.taglib.search.TextSearchEntry;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class DateSearchEntry
extends TextSearchEntry {
    private Date _date;
    private Locale _locale;
    private TimeZone _timeZone;

    public Date getDate() {
        return this._date;
    }

    @Override
    public String getName(HttpServletRequest request) {
        if (this._date != null) {
            Object[] localeAndTimeZone = this.getLocaleAndTimeZone(request);
            Locale locale = (Locale)localeAndTimeZone[0];
            Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)locale, (TimeZone)((TimeZone)localeAndTimeZone[1]));
            StringBundler sb = new StringBundler(5);
            sb.append("<span onmouseover=\"Liferay.Portal.ToolTip.show(this, '");
            sb.append(dateFormatDateTime.format(this._date));
            sb.append("')\">");
            if (this._date.before(new Date())) {
                sb.append(LanguageUtil.format((Locale)locale, (String)"x-ago", (Object)LanguageUtil.getTimeDescription((Locale)locale, (long)(System.currentTimeMillis() - this._date.getTime()), (boolean)true), (boolean)false));
            } else {
                sb.append(LanguageUtil.format((Locale)locale, (String)"within-x", (Object)LanguageUtil.getTimeDescription((Locale)locale, (long)(this._date.getTime() - System.currentTimeMillis()), (boolean)true), (boolean)false));
            }
            sb.append("</span>");
            return sb.toString();
        }
        return "";
    }

    public void setDate(Date date) {
        this._date = date;
    }

    protected Object[] getLocaleAndTimeZone(HttpServletRequest request) {
        if (this._locale != null && this._timeZone != null) {
            return new Object[]{this._locale, this._timeZone};
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._locale = themeDisplay.getLocale();
        this._timeZone = themeDisplay.getTimeZone();
        return new Object[]{this._locale, this._timeZone};
    }
}

