/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.ValidatorTagImpl;
import com.liferay.taglib.aui.base.BaseSelectTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class SelectTag
extends BaseSelectTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;
    private Map<String, ValidatorTag> _validators;

    @Override
    public int doEndTag() throws JspException {
        this.updateFormValidators();
        return super.doEndTag();
    }

    @Override
    public int doStartTag() throws JspException {
        this.addRequiredValidatorTag();
        return super.doStartTag();
    }

    protected void addRequiredValidatorTag() {
        if (!this.getRequired()) {
            return;
        }
        ValidatorTagImpl validatorTag = new ValidatorTagImpl("required", null, null, false);
        this.addValidatorTag("required", validatorTag);
    }

    protected void addValidatorTag(String validatorName, ValidatorTag validatorTag) {
        if (this._validators == null) {
            this._validators = new HashMap<String, ValidatorTag>();
        }
        this._validators.put(validatorName, validatorTag);
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        String title;
        String label;
        String id;
        String name;
        int pos;
        super.setAttributes(request);
        Object bean = this.getBean();
        if (bean == null) {
            bean = this.pageContext.getAttribute("aui:model-context:bean");
        }
        if ((pos = (name = this.getName()).indexOf("--")) != -1) {
            name = name.substring(pos + 2, name.length() - 2);
        }
        if (Validator.isNull((String)(id = this.getId()))) {
            id = AUIUtil.normalizeId(name);
        }
        if ((label = this.getLabel()) == null) {
            label = TextFormatter.format((String)name, (int)15);
        }
        String listType = this.getListType();
        String listTypeFieldName = this.getListTypeFieldName();
        if (Validator.isNotNull((String)listType) && Validator.isNull((String)listTypeFieldName)) {
            listTypeFieldName = "typeId";
        }
        if ((title = this.getTitle()) == null && Validator.isNull((String)label)) {
            title = TextFormatter.format((String)name, (int)15);
        }
        String value = String.valueOf(this.getValue());
        if (Validator.isNull((String)listType)) {
            if (bean != null) {
                value = BeanPropertiesUtil.getStringSilent((Object)bean, (String)name, (String)value);
            }
            if (!this.getIgnoreRequestValue()) {
                value = ParamUtil.getString((HttpServletRequest)request, (String)name, (String)value);
            }
        }
        this.setNamespacedAttribute(request, "bean", bean);
        this.setNamespacedAttribute(request, "id", id);
        this.setNamespacedAttribute(request, "label", label);
        this.setNamespacedAttribute(request, "listTypeFieldName", listTypeFieldName);
        this.setNamespacedAttribute(request, "title", String.valueOf(title));
        this.setNamespacedAttribute(request, "value", value);
    }

    protected void updateFormValidators() {
        if (this._validators == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Map validatorTagsMap = (Map)request.getAttribute("aui:form:validatorTagsMap");
        if (validatorTagsMap != null) {
            List validatorTags = ListUtil.fromMapValues(this._validators);
            validatorTagsMap.put(this.getName(), validatorTags);
        }
    }
}

