/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.servlet.taglib.BodyContentWrapper;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.taglib.aui.base.BaseScriptTag;
import com.liferay.taglib.util.PortalIncludeUtil;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;

public class ScriptTag
extends BaseScriptTag {
    public static void doTag(String position, String require, String use, String bodyContentString, BodyContent previousBodyContent, PageContext pageContext) throws Exception {
        String previousBodyContentString = null;
        if (previousBodyContent != null && !(previousBodyContent instanceof BodyContentWrapper)) {
            previousBodyContentString = previousBodyContent.getString();
        }
        ScriptTag scriptTag = new ScriptTag();
        scriptTag.setPageContext(pageContext);
        scriptTag.setPosition(position);
        scriptTag.setRequire(require);
        scriptTag.setUse(use);
        BodyContent bodyContent = pageContext.pushBody();
        scriptTag.setBodyContent(bodyContent);
        bodyContent.write(bodyContentString);
        pageContext.popBody();
        scriptTag.doEndTag();
        scriptTag.release();
        if (previousBodyContentString != null) {
            previousBodyContent.clear();
            previousBodyContent.append((CharSequence)previousBodyContentString);
        }
    }

    public static void flushScriptData(PageContext pageContext) throws Exception {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        ScriptData scriptData = (ScriptData)request.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
        if (scriptData == null) {
            return;
        }
        request.removeAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
        scriptData.writeTo((Writer)pageContext.getOut());
    }

    @Override
    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            ScriptData scriptData;
            String portletId = null;
            Portlet portlet = (Portlet)request.getAttribute("RENDER_PORTLET");
            if (portlet != null) {
                portletId = portlet.getPortletId();
            }
            StringBundler bodyContentSB = this.getBodyContentAsStringBundler();
            String require = this.getRequire();
            String use = this.getUse();
            if (require != null && use != null) {
                throw new JspException("Attributes \"require\" and \"use\" are both set");
            }
            if (this.getSandbox() || require != null || use != null) {
                StringBundler sb = new StringBundler();
                if (require == null && use == null) {
                    sb.append("(function() {");
                }
                sb.append("var $ = AUI.$;");
                sb.append("var _ = AUI._;");
                sb.append(bodyContentSB);
                if (require == null && use == null) {
                    sb.append("})();");
                }
                bodyContentSB = sb;
            }
            if (this.isPositionInLine()) {
                scriptData = new ScriptData();
                if (require != null) {
                    scriptData.append(portletId, bodyContentSB, require, ScriptData.ModulesType.ES6);
                } else {
                    scriptData.append(portletId, bodyContentSB, use, ScriptData.ModulesType.AUI);
                }
                String page = this.getPage();
                if (FileAvailabilityUtil.isAvailable(this.pageContext.getServletContext(), page)) {
                    PortalIncludeUtil.include(this.pageContext, page);
                } else {
                    scriptData.writeTo((Writer)this.pageContext.getOut());
                }
            } else {
                scriptData = (ScriptData)request.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
                if (scriptData == null) {
                    scriptData = new ScriptData();
                    request.setAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA", (Object)scriptData);
                }
                if (require != null) {
                    scriptData.append(portletId, bodyContentSB, require, ScriptData.ModulesType.ES6);
                } else {
                    scriptData.append(portletId, bodyContentSB, use, ScriptData.ModulesType.AUI);
                }
            }
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!ServerDetector.isResin()) {
                this.cleanUp();
            }
            request.removeAttribute("JAVASCRIPT_CONTEXT");
        }
    }

    @Override
    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        request.setAttribute("JAVASCRIPT_CONTEXT", (Object)Boolean.TRUE);
        return super.doStartTag();
    }

    @Override
    protected void cleanUp() {
        this.setPosition(null);
        this.setRequire(null);
        this.setUse(null);
    }
}

