/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.NavBarTag;
import com.liferay.taglib.aui.base.BaseNavTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ResourceBundle;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;

public class NavTag
extends BaseNavTag
implements BodyTag {
    private boolean _calledCollapsibleSetter;
    private String _namespacedId;

    @Override
    public int doStartTag() throws JspException {
        NavBarTag navBarTag = (NavBarTag)NavTag.findAncestorWithClass(this, NavBarTag.class);
        if (navBarTag != null && (!this._calledCollapsibleSetter || this.getCollapsible())) {
            this.setCollapsible(true);
            navBarTag.setDataTarget(this._getNamespacedId());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            StringBundler sb = navBarTag.getResponsiveButtonsSB();
            sb.append("<a class=\"btn navbar-btn navbar-toggle");
            String cssClass = this.getCssClass();
            if (Validator.isNotNull((String)cssClass)) {
                String[] cssClassParts = StringUtil.split((String)cssClass, (char)' ');
                for (int i = 0; i < cssClassParts.length; ++i) {
                    sb.append(" ");
                    sb.append(cssClassParts[i]);
                    sb.append("-btn");
                }
            }
            if (this._hasSearchResults()) {
                sb.append(" hide");
            }
            sb.append("\" id=\"");
            sb.append(this._getNamespacedId());
            sb.append("NavbarBtn\" data-navId=\"");
            sb.append(this._getNamespacedId());
            sb.append("\" tabindex=\"0\">");
            String icon = this.getIcon();
            if (Validator.isNull((String)icon)) {
                sb.append("<i class=\"icon-reorder\"></i>");
            } else if (icon.equals("user") && themeDisplay.isSignedIn()) {
                try {
                    sb.append("<img alt=\"");
                    ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                    sb.append(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"my-account"));
                    sb.append("\" class=\"user-avatar-image\" src=\"");
                    User user = themeDisplay.getUser();
                    sb.append(user.getPortraitURL(themeDisplay));
                    sb.append("\">");
                }
                catch (Exception e) {
                    throw new JspException((Throwable)e);
                }
            } else {
                sb.append("<i class=\"icon-");
                sb.append(icon);
                sb.append("\"></i>");
            }
            sb.append("</a>");
        }
        return super.doStartTag();
    }

    @Override
    public void setCollapsible(boolean collapsible) {
        super.setCollapsible(collapsible);
        this._calledCollapsibleSetter = true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._calledCollapsibleSetter = false;
        this._namespacedId = null;
    }

    protected String getMarkupView() {
        String markupView = "";
        NavBarTag navBarTag = (NavBarTag)NavTag.findAncestorWithClass(this, NavBarTag.class);
        if (navBarTag != null) {
            markupView = navBarTag.getMarkupView();
        }
        return markupView;
    }

    @Override
    protected String getPage() {
        if (Validator.isNotNull((String)this.getMarkupView())) {
            return "/html/taglib/aui/nav/" + this.getMarkupView() + "/page.jsp";
        }
        return "/html/taglib/aui/nav/page.jsp";
    }

    @Override
    protected int processStartTag() throws Exception {
        return 2;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        super.setAttributes(request);
        this.setNamespacedAttribute(request, "id", this._getNamespacedId());
    }

    private String _getNamespacedId() {
        PortletResponse portletResponse;
        if (Validator.isNotNull((String)this._namespacedId)) {
            return this._namespacedId;
        }
        this._namespacedId = this.getId();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (Validator.isNull((String)this._namespacedId)) {
            this._namespacedId = PortalUtil.getUniqueElementId((HttpServletRequest)request, (String)"", (String)AUIUtil.normalizeId("navTag"));
        }
        if ((portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response")) != null && this.getUseNamespace()) {
            this._namespacedId = portletResponse.getNamespace() + this._namespacedId;
        }
        return this._namespacedId;
    }

    private boolean _hasSearchResults() {
        SearchContainer<?> searchContainer = this.getSearchContainer();
        if (searchContainer == null) {
            return false;
        }
        DisplayTerms displayTerms = searchContainer.getDisplayTerms();
        String keywords = displayTerms.getKeywords();
        return displayTerms.isAdvancedSearch() || !keywords.equals("");
    }
}

