/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.NavBarTag;
import com.liferay.taglib.aui.base.BaseNavBarSearchTag;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class NavBarSearchTag
extends BaseNavBarSearchTag {
    private String _namespacedId;

    @Override
    public int doStartTag() throws JspException {
        NavBarTag navBarTag = (NavBarTag)NavBarSearchTag.findAncestorWithClass(this, NavBarTag.class);
        if (navBarTag != null) {
            StringBundler sb = navBarTag.getResponsiveButtonsSB();
            sb.append("<a class=\"btn navbar-btn navbar-toggle");
            if (this._hasSearchResults()) {
                sb.append(" hide");
            }
            sb.append("\" id=\"");
            sb.append(this._getNamespacedId());
            sb.append("NavbarBtn\" data-navId=\"");
            sb.append(this._getNamespacedId());
            sb.append("\" tabindex=\"0\">");
            sb.append("<i class=\"icon-search\"></i></a>");
        }
        return super.doStartTag();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._namespacedId = null;
    }

    @Override
    protected String getEndPage() {
        if (Validator.isNotNull((String)this.getMarkupView())) {
            return "/html/taglib/aui/nav_bar_search/" + this.getMarkupView() + "/end.jsp";
        }
        return "/html/taglib/aui/nav_bar_search/end.jsp";
    }

    protected String getMarkupView() {
        String markupView = "";
        NavBarTag navBarTag = (NavBarTag)NavBarSearchTag.findAncestorWithClass(this, NavBarTag.class);
        if (navBarTag != null) {
            markupView = navBarTag.getMarkupView();
        }
        return markupView;
    }

    @Override
    protected String getStartPage() {
        if (Validator.isNotNull((String)this.getMarkupView())) {
            return "/html/taglib/aui/nav_bar_search/" + this.getMarkupView() + "/start.jsp";
        }
        return "/html/taglib/aui/nav_bar_search/start.jsp";
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        super.setAttributes(request);
        this.setNamespacedAttribute(request, "id", this._getNamespacedId());
        this.setNamespacedAttribute(request, "searchResults", this._hasSearchResults());
    }

    private String _getNamespacedId() {
        PortletResponse portletResponse;
        if (Validator.isNotNull((String)this._namespacedId)) {
            return this._namespacedId;
        }
        this._namespacedId = this.getId();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (Validator.isNull((String)this._namespacedId)) {
            this._namespacedId = PortalUtil.getUniqueElementId((HttpServletRequest)request, (String)"", (String)AUIUtil.normalizeId("navBar"));
        }
        if ((portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response")) != null) {
            this._namespacedId = portletResponse.getNamespace() + this._namespacedId;
        }
        return this._namespacedId;
    }

    private boolean _hasSearchResults() {
        SearchContainer<?> searchContainer = this.getSearchContainer();
        if (searchContainer == null) {
            return false;
        }
        DisplayTerms displayTerms = searchContainer.getDisplayTerms();
        String keywords = displayTerms.getKeywords();
        return displayTerms.isAdvancedSearch() || !keywords.equals("");
    }
}

