/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class AUIUtil {
    public static final String BUTTON_PREFIX = "btn";
    public static final String FIELD_PREFIX = "field";
    private static final Pattern _friendlyURLPattern = Pattern.compile("[^A-Za-z0-9/_-]");

    public static String buildControlGroupCss(boolean inlineField, String inlineLabel, String wrapperCssClass, String baseType) {
        StringBundler sb = new StringBundler(9);
        sb.append("form-group");
        if (inlineField) {
            sb.append(" form-group-inline");
        }
        if (Validator.isNotNull((String)inlineLabel)) {
            sb.append(" form-inline");
        }
        if (Validator.isNotNull((String)wrapperCssClass)) {
            sb.append(" ");
            sb.append(wrapperCssClass);
        }
        if (Validator.isNotNull((String)baseType)) {
            sb.append(" ");
            sb.append("input-");
            sb.append(baseType);
            sb.append("-wrapper");
        }
        return sb.toString();
    }

    public static String buildCss(String prefix, boolean disabled, boolean first, boolean last, String cssClass) {
        StringBundler sb = new StringBundler(8);
        sb.append(prefix);
        if (disabled) {
            sb.append(" ");
            sb.append("disabled");
        }
        if (first) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-first");
        } else if (last) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-last");
        }
        if (Validator.isNotNull((String)cssClass)) {
            sb.append(" ");
            sb.append(cssClass);
        }
        return sb.toString();
    }

    public static String buildData(Map<String, Object> data) {
        return HtmlUtil.buildData(data);
    }

    public static String buildLabel(String baseType, boolean inlineField, boolean showForLabel, String forLabel) {
        StringBundler sb = new StringBundler(7);
        if (baseType.equals("boolean")) {
            baseType = "checkbox";
        }
        if (baseType.equals("checkbox") || baseType.equals("radio")) {
            if (inlineField) {
                sb.append("class=\"");
                sb.append(baseType);
                sb.append("-inline\" ");
            }
        } else {
            sb.append("class=\"control-label\" ");
        }
        if (showForLabel) {
            sb.append("for=\"");
            sb.append(HtmlUtil.escapeAttribute((String)forLabel));
            sb.append("\"");
        }
        return sb.toString();
    }

    public static Object getAttribute(HttpServletRequest request, String namespace, String key) {
        Map dynamicAttributes = (Map)request.getAttribute(namespace.concat("dynamicAttributes"));
        Map scopedAttributes = (Map)request.getAttribute(namespace.concat("scopedAttributes"));
        if (dynamicAttributes != null && dynamicAttributes.containsKey(key) || scopedAttributes != null && scopedAttributes.containsKey(key)) {
            return request.getAttribute(namespace.concat(key));
        }
        return null;
    }

    public static String getNamespace(HttpServletRequest request) {
        return GetterUtil.getString((Object)request.getAttribute("aui:form:portletNamespace"));
    }

    public static String getNamespace(PortletRequest portletRequest, PortletResponse portletResponse) {
        String namespace = "";
        if (portletRequest == null) {
            return namespace;
        }
        boolean auiFormUseNamespace = GetterUtil.getBoolean((String)((String)portletRequest.getAttribute("aui:form:useNamespace")), (boolean)true);
        if (portletResponse != null && auiFormUseNamespace) {
            namespace = GetterUtil.getString((Object)portletRequest.getAttribute("aui:form:portletNamespace"), (String)portletResponse.getNamespace());
        }
        return namespace;
    }

    public static boolean isOpensNewWindow(String target) {
        return target != null && (target.equals("_blank") || target.equals("_new"));
    }

    public static String normalizeId(String name) {
        Matcher matcher = _friendlyURLPattern.matcher(name);
        return matcher.replaceAll("-");
    }
}

