/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.aui.base.BaseATag;
import com.liferay.taglib.util.InlineUtil;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class ATag
extends BaseATag {
    @Override
    protected int processEndTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        if (Validator.isNotNull((String)this.getHref())) {
            if (AUIUtil.isOpensNewWindow(this.getTarget())) {
                ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                jspWriter.write(" ");
                jspWriter.write("<svg class=\"lexicon-icon ");
                jspWriter.write("lexicon-icon-shortcut\" role=\"img\"><use ");
                jspWriter.write("xlink:href=\"");
                jspWriter.write(themeDisplay.getPathThemeImages());
                jspWriter.write("/lexicon/icons.svg#shortcut\" /><span ");
                jspWriter.write("class=\"sr-only\">");
                jspWriter.write(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"opens-new-window"));
                jspWriter.write("</span></svg>");
            }
            jspWriter.write("</a>");
        } else {
            jspWriter.write("</span>");
        }
        return 6;
    }

    @Override
    protected int processStartTag() throws Exception {
        ResourceBundle resourceBundle;
        JspWriter jspWriter = this.pageContext.getOut();
        String ariaRole = this.getAriaRole();
        String cssClass = this.getCssClass();
        Map<String, Object> data = this.getData();
        String href = this.getHref();
        String id = this.getId();
        String iconCssClass = this.getIconCssClass();
        String label = this.getLabel();
        String lang = this.getLang();
        Boolean localizeLabel = this.getLocalizeLabel();
        String namespace = this._getNamespace();
        String onClick = this.getOnClick();
        String target = this.getTarget();
        String title = this.getTitle();
        if (Validator.isNotNull((String)href)) {
            jspWriter.write("<a ");
            jspWriter.write("href=\"");
            jspWriter.write(HtmlUtil.escapeAttribute((String)href));
            jspWriter.write("\" ");
            if (Validator.isNotNull((String)target)) {
                jspWriter.write("target=\"");
                jspWriter.write(target);
                jspWriter.write("\" ");
            }
        } else {
            jspWriter.write("<span ");
        }
        if (Validator.isNotNull((String)cssClass)) {
            jspWriter.write("class=\"");
            jspWriter.write(cssClass);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull((String)id)) {
            jspWriter.write("id=\"");
            jspWriter.write(namespace);
            jspWriter.write(id);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull((String)lang)) {
            jspWriter.write("lang=\"");
            jspWriter.write(lang);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull((String)onClick)) {
            jspWriter.write("onClick=\"");
            jspWriter.write(onClick);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull((String)ariaRole)) {
            jspWriter.write("role=\"");
            jspWriter.write(ariaRole);
            jspWriter.write("\" ");
        }
        if (Validator.isNotNull((String)title) || AUIUtil.isOpensNewWindow(this.getTarget())) {
            resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
            jspWriter.write("title=\"");
            if (Validator.isNotNull((String)title)) {
                jspWriter.write(LanguageUtil.get((ResourceBundle)resourceBundle, (String)title));
            }
            if (AUIUtil.isOpensNewWindow(this.getTarget())) {
                jspWriter.write(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"opens-new-window"));
            }
            jspWriter.write("\" ");
        }
        if (data != null) {
            jspWriter.write(AUIUtil.buildData(data));
        }
        this._writeDynamicAttributes(jspWriter);
        jspWriter.write(">");
        if (Validator.isNotNull((String)label)) {
            if (localizeLabel.booleanValue()) {
                resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                jspWriter.write(LanguageUtil.get((ResourceBundle)resourceBundle, (String)label));
            } else {
                jspWriter.write(label);
            }
        }
        if (Validator.isNotNull((String)iconCssClass)) {
            jspWriter.write("<span class=\"icon-monospaced ");
            jspWriter.write(iconCssClass);
            jspWriter.write("\"></span>");
        }
        return 1;
    }

    private String _getNamespace() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        String namespace = "";
        boolean useNamespace = GetterUtil.getBoolean((String)((String)request.getAttribute("aui:form:useNamespace")), (boolean)true);
        if (portletResponse != null && useNamespace) {
            namespace = portletResponse.getNamespace();
        }
        return namespace;
    }

    private void _writeDynamicAttributes(JspWriter jspWriter) throws IOException {
        String dynamicAttributesString = InlineUtil.buildDynamicAttributes(this.getDynamicAttributes());
        if (Validator.isNotNull((String)dynamicAttributesString)) {
            jspWriter.write(dynamicAttributesString);
        }
    }
}

