/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib;

import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileAvailabilityUtil {
    public static void clearAvailabilities() {
        String servletContextName = PortalUtil.getServletContextName();
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        Map availabilities = (Map)servletContext.getAttribute(FileAvailabilityUtil.class.getName());
        if (availabilities != null) {
            servletContext.removeAttribute(FileAvailabilityUtil.class.getName());
        }
    }

    public static boolean isAvailable(ServletContext servletContext, String path) {
        if (Validator.isNull((String)path)) {
            return false;
        }
        if (path.charAt(0) != '/') {
            return true;
        }
        Map<String, Boolean> availabilities = FileAvailabilityUtil._getAvailabilities(servletContext);
        Boolean available = availabilities.get(path);
        if (available != null) {
            return available;
        }
        URL url = null;
        try {
            url = AccessController.doPrivileged(new ResourcePrivilegedExceptionAction(servletContext, path));
        }
        catch (Exception e) {
            // empty catch block
        }
        available = url == null && !PortalWebResourcesUtil.isAvailable((String)path) ? Boolean.FALSE : Boolean.TRUE;
        availabilities.put(path, available);
        return available;
    }

    private static Map<String, Boolean> _getAvailabilities(ServletContext servletContext) {
        ConcurrentHashMap availabilities = (ConcurrentHashMap)servletContext.getAttribute(FileAvailabilityUtil.class.getName());
        if (availabilities == null) {
            availabilities = new ConcurrentHashMap();
            servletContext.setAttribute(FileAvailabilityUtil.class.getName(), availabilities);
        }
        return availabilities;
    }

    private static class ResourcePrivilegedExceptionAction
    implements PrivilegedExceptionAction<URL> {
        private final String _path;
        private final ServletContext _servletContext;

        public ResourcePrivilegedExceptionAction(ServletContext servletContext, String path) {
            this._servletContext = servletContext;
            this._path = path;
        }

        @Override
        public URL run() throws Exception {
            return this._servletContext.getResource(this._path);
        }
    }
}

