/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.tools.xmlbuilder;

import com.liferay.alloy.tools.model.Attribute;
import com.liferay.alloy.tools.model.Component;
import com.liferay.alloy.util.DefaultValueUtil;
import com.liferay.alloy.util.JSONUtil;
import com.liferay.alloy.util.TypeUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class XMLBuilder {
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_TAGLIB_SHORT_NAME = "alloy";
    private static final String _DEFAULT_TAGLIB_URI = "http://alloy.liferay.com/tld/alloy";
    private static final String _DEFAULT_TAGLIB_VERSION = "1.0";
    private static final String _DEFAULT_TYPE = Object.class.getName();
    private static final String _HTML_COMMENT_END = "-->";
    private static final String _HTML_COMMENT_START = "<!--";
    private static final String AUI_PREFIX = "aui-";
    private JSONObject _classMapJSON;
    private List<String> _componentExcluded;
    private String _componentJSON;
    private String _componentXML;
    private File _fileJSON;
    private File _fileXML;
    private JSONObject _json;

    public static void main(String[] args) throws Exception {
        String componentsJSON = System.getProperty("xmlbuilder.components.json");
        String componentsXML = System.getProperty("tagbuilder.components.xml");
        String componentExcluded = System.getProperty("xmlbuilder.components.excluded");
        new XMLBuilder(componentsJSON, componentsXML, componentExcluded);
    }

    public XMLBuilder(String componentsJSON, String componentsXML, String componentExcluded) throws Exception {
        if (FileUtil.getFile() == null) {
            new FileUtil().setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        }
        if (SAXReaderUtil.getSAXReader() == null) {
            new SAXReaderUtil().setSAXReader((SAXReader)new SAXReaderImpl());
        }
        this._componentJSON = componentsJSON;
        this._componentXML = componentsXML;
        this._componentExcluded = Arrays.asList(StringUtil.split((String)componentExcluded));
        this._fileXML = new File(this._componentXML);
        this._fileJSON = new File(this._componentJSON);
        this._json = new JSONObject(FileUtil.read((File)this._fileJSON));
        this._classMapJSON = this._json.getJSONObject("classmap");
        this._create();
    }

    public ArrayList<Attribute> getComponentAttributes(String className) {
        return this._getComponentAttributes(className, "configs");
    }

    public ArrayList<Attribute> getComponentEvents(String className) {
        return this._getComponentAttributes(className, "events");
    }

    public ArrayList<String> getComponentHierarchy(String className) {
        return this._getComponentHierarchy(className, new ArrayList<String>());
    }

    public ArrayList<Component> getComponents() {
        HashSet<Component> components = new HashSet<Component>();
        Iterator it = this._classMapJSON.keys();
        while (it.hasNext()) {
            String className = (String)it.next();
            JSONObject componentJSON = JSONUtil.getJSONObject(this._classMapJSON, className);
            String namespace = GetterUtil.getString((String)"alloy");
            String name = JSONUtil.getString(componentJSON, "name");
            String module = GetterUtil.getString((String)JSONUtil.getString(componentJSON, "module"), (String)name);
            boolean bodyContent = GetterUtil.getBoolean((String)JSONUtil.getString(componentJSON, "bodyContent"));
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.getComponentAttributes(className));
            ArrayList<Attribute> events = new ArrayList<Attribute>(this.getComponentEvents(className));
            Component component = new Component();
            component.setAlloyComponent(true);
            component.setAttributes(attributes);
            component.setAuthors(null);
            component.setBodyContent(bodyContent);
            component.setEvents(events);
            component.setModule(module);
            component.setName(name);
            component.setPackage(namespace);
            if (this.isExcludedComponent(component)) continue;
            components.add(component);
        }
        ArrayList<Component> sortedComponents = new ArrayList<Component>(components);
        Collections.sort(sortedComponents);
        return sortedComponents;
    }

    public boolean isExcludedComponent(Component component) {
        String module = component.getModule();
        return !module.startsWith(AUI_PREFIX) || this._componentExcluded.contains(component.getName());
    }

    private void _create() throws Exception {
        this._createXML();
    }

    private void _createXML() {
        ArrayList<Component> components = this.getComponents();
        Document doc = DocumentFactory.getInstance().createDocument();
        Element root = doc.addElement("taglibs");
        root.addAttribute("short-name", "alloy");
        root.addAttribute("uri", _DEFAULT_TAGLIB_URI);
        root.addAttribute("tlib-version", _DEFAULT_TAGLIB_VERSION);
        for (Component component : components) {
            Element nameNode;
            Element componentNode = root.addElement("component");
            componentNode.addAttribute("name", component.getName());
            componentNode.addAttribute("module", component.getModule());
            componentNode.addAttribute("package", component.getPackage());
            componentNode.addAttribute("bodyContent", String.valueOf(component.isBodyContent()));
            componentNode.addAttribute("alloyComponent", String.valueOf(component.isAlloyComponent()));
            Element attributesNode = componentNode.addElement("attributes");
            Element eventsNode = componentNode.addElement("events");
            for (Attribute attribute : component.getAttributes()) {
                Element attributeNode = attributesNode.addElement("attribute");
                nameNode = attributeNode.addElement("name");
                Element inputTypeNode = attributeNode.addElement("inputType");
                Element outputTypeNode = attributeNode.addElement("outputType");
                Element defaultValueNode = attributeNode.addElement("defaultValue");
                Element descriptionNode = attributeNode.addElement("description");
                nameNode.setText(attribute.getName());
                inputTypeNode.setText(attribute.getInputType());
                outputTypeNode.setText(attribute.getOutputType());
                defaultValueNode.setText(attribute.getDefaultValue());
                descriptionNode.addCDATA(this._getAttributeDescription(attribute));
            }
            for (Attribute event : component.getEvents()) {
                Element eventNode = eventsNode.addElement("event");
                nameNode = eventNode.addElement("name");
                Element typeNode = eventNode.addElement("type");
                Element descriptionNode = eventNode.addElement("description");
                nameNode.setText(event.getName());
                typeNode.setText(event.getInputType());
                descriptionNode.addCDATA(this._getAttributeDescription(event));
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this._componentXML);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(doc);
            writer.flush();
            System.out.println("Writing " + this._componentXML);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String _getAttributeDescription(Attribute attribute) {
        JSONObject descriptionJSON = new JSONObject();
        try {
            String defaultValue = attribute.getDefaultValue();
            if (Validator.isNotNull((String)defaultValue)) {
                descriptionJSON.put("defaultValue", (Object)defaultValue);
            }
            descriptionJSON.put("event", attribute.isEvent());
            descriptionJSON.put("inputType", (Object)attribute.getInputType());
            descriptionJSON.put("outputType", (Object)attribute.getOutputType());
            descriptionJSON.put("required", attribute.isRequired());
        }
        catch (JSONException jsone) {
            jsone.printStackTrace();
        }
        StringBundler sb = new StringBundler(attribute.getDescription());
        sb.append(_HTML_COMMENT_START);
        sb.append(descriptionJSON.toString());
        sb.append(_HTML_COMMENT_END);
        return sb.toString();
    }

    private ArrayList<Attribute> _getComponentAttributes(String className, String attributeType) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ArrayList<String> hierarchy = this.getComponentHierarchy(className);
        try {
            for (String parentClass : hierarchy) {
                JSONObject typeJSON;
                JSONObject componentJSON = JSONUtil.getJSONObject(this._classMapJSON, parentClass);
                if (componentJSON == null || (typeJSON = JSONUtil.getJSONObject(componentJSON, attributeType)) == null) continue;
                Iterator it = typeJSON.keys();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    JSONObject attributeJSON = JSONUtil.getJSONObject(typeJSON, name);
                    String inputType = GetterUtil.getString((String)JSONUtil.getString(attributeJSON, "type"), (String)_DEFAULT_TYPE);
                    String outputType = GetterUtil.getString((String)JSONUtil.getString(attributeJSON, "type"), (String)_DEFAULT_TYPE);
                    String outputJavaType = TypeUtil.getOutputJavaType(outputType, true);
                    String defaultValue = DefaultValueUtil.getDefaultValue(outputJavaType, JSONUtil.getString(attributeJSON, "default"));
                    String description = GetterUtil.getString((String)JSONUtil.getString(attributeJSON, "description"));
                    boolean required = GetterUtil.getBoolean((String)JSONUtil.getString(attributeJSON, "required"));
                    Attribute attribute = new Attribute();
                    attribute.setName(name);
                    attribute.setInputType(inputType);
                    attribute.setOutputType(outputType);
                    attribute.setDefaultValue(defaultValue);
                    attribute.setDescription(description);
                    attribute.setRequired(required);
                    attributes.add(attribute);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Attribute> sortedAttributes = new ArrayList<Attribute>(attributes);
        Collections.sort(sortedAttributes);
        return sortedAttributes;
    }

    private ArrayList<String> _getComponentHierarchy(String className, ArrayList<String> hierarchy) {
        try {
            JSONObject componentJSON = JSONUtil.getJSONObject(this._classMapJSON, className);
            if (componentJSON != null) {
                hierarchy.add(className);
                String extendClass = JSONUtil.getString(componentJSON, "extends");
                if (extendClass != null) {
                    this._getComponentHierarchy(extendClass, hierarchy);
                }
                hierarchy.addAll(JSONUtil.getList(componentJSON, "uses"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hierarchy;
    }
}

