/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.tools.tagbuilder;

import com.liferay.alloy.tools.model.Attribute;
import com.liferay.alloy.tools.model.Component;
import com.liferay.alloy.util.TypeUtil;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TagBuilder {
    public static final String[] DEFAULT_AUTHORS = new String[]{"Eduardo Lundgren", "Bruno Basto", "Nathan Cavanaugh"};
    private static final String _AFTER = "after";
    private static final String _ATTRIBUTE = "attribute";
    private static final String _ATTRIBUTES = "attributes";
    private static final String _AUI = "aui";
    private static final String _AUTHOR = "author";
    private static final String _AUTHORS = "authors";
    private static final String _BASE = "base";
    private static final String _BASE_CLASS_PREFIX = "Base";
    private static final String _CLASS_SUFFIX = ".java";
    private static final String _COMPONENT = "component";
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_PARENT_CLASS = "com.liferay.taglib.util.IncludeTag";
    private static final String _DEFAULT_TAGLIB_SHORT_NAME = "alloy";
    private static final String _DEFAULT_TAGLIB_URI = "http://alloy.liferay.com/tld/alloy";
    private static final String _DEFAULT_TAGLIB_VERSION = "1.0";
    private static final String _DEFAULT_TYPE = "java.lang.Object";
    private static final String _END_PAGE = "/end.jsp";
    private static final String _EVENT = "event";
    private static final String _EVENTS = "events";
    private static final String _INIT_EXT_PAGE = "/init-ext.jspf";
    private static final String _INIT_PAGE = "/init.jsp";
    private static final String _LIFERAY = "liferay";
    private static final String _ON = "on";
    private static final String _PAGE = "/page.jsp";
    private static final String _SERVLET_CONTEXT_UTIL = "ServletContextUtil";
    private static final String _START_PAGE = "/start.jsp";
    private static final String _TAGLIB = "taglib";
    private static final String _TLD_EXTENSION = ".tld";
    private static final String _TLD_XPATH_PREFIX = "tld";
    private static final String _TLD_XPATH_URI = "http://java.sun.com/xml/ns/j2ee";
    private static String _copyrightYear;
    private List<Document> _componentsExtDoc;
    private List<String> _componentsXML;
    private String _javaDir;
    private String _javaPackage;
    private String _jspCommonInitPath;
    private String _jspDir;
    private String _jspParentDir;
    private String _OSGIModuleSymbolicName;
    private String _templatesDir;
    private String _tldDir;
    private String _tplCommonInitJsp;
    private String _tplEndJsp;
    private String _tplInitJsp;
    private String _tplJsp;
    private String _tplServletContextUtil;
    private String _tplStartJsp;
    private String _tplTag;
    private String _tplTagBase;
    private String _tplTld;

    public static void main(String[] args) throws Exception {
        String componentsXML = System.getProperty("tagbuilder.components.xml");
        String copyrightYear = System.getProperty("tagbuilder.copyright.year");
        String jspParentDir = System.getProperty("tagbuilder.jsp.parent.dir");
        String javaDir = System.getProperty("tagbuilder.java.dir");
        String javaPackage = System.getProperty("tagbuilder.java.package");
        String jspCommonInitPath = System.getProperty("tagbuilder.jsp.common.init.path");
        String jspDir = System.getProperty("tagbuilder.jsp.dir");
        String OSGIModuleSymbolicName = System.getProperty("tagbuilder.osgi.module.symbolic.name");
        String templatesDir = System.getProperty("tagbuilder.templates.dir");
        String tldDir = System.getProperty("tagbuilder.tld.dir");
        Calendar calendar = Calendar.getInstance();
        _copyrightYear = String.valueOf(calendar.get(1));
        if (Validator.isNotNull((String)copyrightYear)) {
            _copyrightYear = copyrightYear;
        }
        new TagBuilder(componentsXML, templatesDir, javaDir, jspParentDir, javaPackage, jspDir, jspCommonInitPath, OSGIModuleSymbolicName, tldDir);
    }

    public TagBuilder(String componentsXML, String templatesDir, String javaDir, String jspParentDir, String javaPackage, String jspDir, String jspCommonInitPath, String OSGIModuleSymbolicName, String tldDir) throws Exception {
        if (PropsUtil.getProps() == null) {
            PropsUtil.setProps((Props)new PropsImpl());
        }
        if (SAXReaderUtil.getSAXReader() == null) {
            new SAXReaderUtil().setSAXReader((SAXReader)new SAXReaderImpl());
        }
        this._componentsXML = Arrays.asList(StringUtil.split((String)componentsXML));
        this._templatesDir = templatesDir;
        this._javaDir = javaDir;
        this._jspParentDir = jspParentDir;
        this._javaPackage = javaPackage;
        this._jspDir = jspDir;
        this._jspCommonInitPath = jspCommonInitPath;
        this._OSGIModuleSymbolicName = OSGIModuleSymbolicName;
        this._tldDir = tldDir;
        this._tplCommonInitJsp = this._templatesDir + "common_init_jsp.ftl";
        this._tplEndJsp = this._templatesDir + "end_jsp.ftl";
        this._tplInitJsp = this._templatesDir + "init_jsp.ftl";
        this._tplJsp = this._templatesDir + "jsp.ftl";
        this._tplStartJsp = this._templatesDir + "start_jsp.ftl";
        this._tplServletContextUtil = this._templatesDir + "servlet_context_util.ftl";
        this._tplTag = this._templatesDir + "tag.ftl";
        this._tplTagBase = this._templatesDir + "tag_base.ftl";
        this._tplTld = this._templatesDir + "tld.ftl";
        this._componentsExtDoc = new ArrayList<Document>();
        for (String componentExtXML : this._componentsXML) {
            File extFile = new File(componentExtXML);
            if (!extFile.exists()) continue;
            this._componentsExtDoc.add(SAXReaderUtil.read((File)extFile));
        }
        this._create();
    }

    protected List<Component> getAllComponents() throws Exception {
        Document doc = SAXReaderUtil.createDocument();
        Document taglibsDoc = SAXReaderUtil.read((String)"<taglibs></taglibs>");
        Element root = taglibsDoc.getRootElement();
        for (Document extDoc : this._componentsExtDoc) {
            Element extRoot = extDoc.getRootElement();
            boolean OSGIModule = GetterUtil.getBoolean((String)extRoot.attributeValue("osgi-module"));
            String extComponentTaglibOSGIModule = String.valueOf(OSGIModule);
            String defaultPackage = extRoot.attributeValue("short-name");
            List extComponentNodes = extRoot.elements(_COMPONENT);
            for (Element extComponent : extComponentNodes) {
                extComponent.addAttribute("componentTaglibOSGIModule", extComponentTaglibOSGIModule);
                String extComponentPackage = GetterUtil.getString((String)extComponent.attributeValue("package"), (String)defaultPackage);
                extComponent.addAttribute("package", extComponentPackage);
            }
            Document parentDoc = this.getComponentsDocByShortName(extDoc.getRootElement().attributeValue("extends"));
            if (parentDoc != null) {
                extDoc = this.mergeXMLAttributes(extDoc, parentDoc);
            }
            Element authors = extRoot.element(_AUTHORS);
            List components = extRoot.elements(_COMPONENT);
            for (Element component : components) {
                Element copy = component.createCopy();
                Element componentAuthors = copy.element(_AUTHORS);
                if (authors != null && componentAuthors == null) {
                    copy.add(authors.createCopy());
                }
                root.add(copy);
            }
        }
        doc.add(root.createCopy());
        return this.getComponents(doc);
    }

    protected List<Attribute> getAttributes(Element componentNode) {
        return this.getAttributes(componentNode, _ATTRIBUTES, _ATTRIBUTE);
    }

    protected List<Attribute> getAttributes(Element componentNode, String group, String nodeName) {
        List nodes = Collections.emptyList();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Element node = componentNode.element(group);
        if (node != null) {
            nodes = node.elements(nodeName);
        }
        for (Element attributeNode : nodes) {
            String defaultValue = attributeNode.elementText("defaultValue");
            String description = attributeNode.elementText("description");
            String name = attributeNode.elementText("name");
            String type = GetterUtil.getString((String)attributeNode.elementText("type"), (String)_DEFAULT_TYPE);
            String inputType = GetterUtil.getString((String)attributeNode.elementText("inputType"), (String)type);
            String outputType = GetterUtil.getString((String)attributeNode.elementText("outputType"), (String)type);
            boolean gettable = GetterUtil.getBoolean((String)attributeNode.elementText("gettable"), (boolean)true);
            boolean required = GetterUtil.getBoolean((String)attributeNode.elementText("required"));
            boolean settable = GetterUtil.getBoolean((String)attributeNode.elementText("settable"), (boolean)true);
            boolean writeInJSP = GetterUtil.getBoolean((String)attributeNode.elementText("writeInJSP"), (boolean)true);
            Attribute attribute = new Attribute();
            attribute.setDefaultValue(defaultValue);
            attribute.setDescription(description);
            attribute.setGettable(gettable);
            attribute.setInputType(inputType);
            attribute.setName(name);
            attribute.setOutputType(outputType);
            attribute.setRequired(required);
            attribute.setSettable(settable);
            attribute.setWriteInJSP(writeInJSP);
            attributes.add(attribute);
        }
        return attributes;
    }

    protected String[] getAuthorList(Element element) {
        Element elAuthors;
        ArrayList<String> authors = new ArrayList<String>();
        if (element != null && (elAuthors = element.element(_AUTHORS)) != null) {
            List authorList = elAuthors.elements(_AUTHOR);
            for (Element author : authorList) {
                authors.add(author.getText());
            }
        }
        if (authors.isEmpty()) {
            return DEFAULT_AUTHORS;
        }
        return authors.toArray(new String[authors.size()]);
    }

    protected Element getComponentNode(Document doc, String name) {
        List components = doc.getRootElement().elements(_COMPONENT);
        for (Element component : components) {
            if (!component.attributeValue("name").equals(name)) continue;
            return component;
        }
        return null;
    }

    protected List<Component> getComponents(Document doc) throws Exception {
        Element root = doc.getRootElement();
        ArrayList<Component> components = new ArrayList<Component>();
        String defaultPackage = root.attributeValue("short-name");
        List allComponentNodes = root.elements(_COMPONENT);
        for (Element node : allComponentNodes) {
            boolean componentTaglibOSGIModule = GetterUtil.getBoolean((String)node.attributeValue("componentTaglibOSGIModule"));
            String componentPackage = GetterUtil.getString((String)node.attributeValue("package"), (String)defaultPackage);
            String name = node.attributeValue("name");
            boolean alloyComponent = GetterUtil.getBoolean((String)node.attributeValue("alloyComponent"));
            boolean bodyContent = GetterUtil.getBoolean((String)node.attributeValue("bodyContent"));
            String className = GetterUtil.getString((String)node.attributeValue("className"));
            String description = node.elementText("description");
            boolean dynamicAttributes = GetterUtil.getBoolean((String)node.attributeValue("dynamicAttributes"), (boolean)true);
            String module = GetterUtil.getString((String)node.attributeValue("module"));
            String parentClass = GetterUtil.getString((String)node.attributeValue("parentClass"), (String)_DEFAULT_PARENT_CLASS);
            boolean writeEndJSP = GetterUtil.getBoolean((String)node.attributeValue("writeEndJSP"), (boolean)true);
            boolean writeJSP = GetterUtil.getBoolean((String)node.attributeValue("writeJSP"), (boolean)true);
            boolean writeStartJSP = GetterUtil.getBoolean((String)node.attributeValue("writeStartJSP"), (boolean)true);
            String[] authors = this.getAuthorList(node);
            List<Attribute> attributes = this.getAttributes(node);
            List<Attribute> events = this.getPrefixedEvents(node);
            Component component = new Component();
            component.setAlloyComponent(alloyComponent);
            component.setAttributes(attributes);
            component.setAuthors(authors);
            component.setBodyContent(bodyContent);
            component.setClassName(className);
            component.setComponentTaglibOSGIModule(componentTaglibOSGIModule);
            component.setDescription(description);
            component.setDynamicAttributes(dynamicAttributes);
            component.setEvents(events);
            component.setModule(module);
            component.setName(name);
            component.setPackage(componentPackage);
            component.setParentClass(parentClass);
            component.setWriteEndJSP(writeEndJSP);
            component.setWriteJSP(writeJSP);
            component.setWriteStartJSP(writeStartJSP);
            components.add(component);
        }
        return components;
    }

    protected Document getComponentsDocByShortName(String name) {
        for (Document doc : this._componentsExtDoc) {
            Element root = doc.getRootElement();
            if (!root.attributeValue("short-name").equals(name)) continue;
            return doc;
        }
        return null;
    }

    protected Map<String, Object> getDefaultTemplateContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("copyrightYear", _copyrightYear);
        context.put("jspCommonInitPath", this._jspCommonInitPath);
        context.put("jspDir", this._jspDir);
        context.put("packagePath", this._javaPackage);
        context.put("typeUtil", TypeUtil.getInstance());
        return context;
    }

    protected Element getElementByName(List<Element> elements, String name) {
        for (Element element : elements) {
            if (!name.equals(element.elementText("name"))) continue;
            return element;
        }
        return null;
    }

    protected String getJavaOutputBaseDir(Component component) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaOutputDir(component));
        sb.append(_BASE);
        sb.append("/");
        return sb.toString();
    }

    protected String getJavaOutputDir(Component component) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._javaDir);
        if (component.isComponentTaglibOSGIModule()) {
            sb.append(_TAGLIB);
            sb.append("/");
        } else {
            sb.append(component.getPackage());
            sb.append("/");
        }
        return sb.toString();
    }

    protected String getJspDir(Component component) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._jspDir);
        if (!component.isComponentTaglibOSGIModule()) {
            sb.append(component.getPackage());
            sb.append("/");
        }
        return sb.toString();
    }

    protected String getJspOutputDir(Component component) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull((String)this._jspParentDir)) {
            sb.append(this._jspParentDir);
            sb.append("/");
        }
        sb.append(this.getJspDir(component));
        return sb.toString();
    }

    protected List<Attribute> getPrefixedEvents(Element componentNode) {
        String name;
        List<Attribute> afterEvents = this.getAttributes(componentNode, _EVENTS, _EVENT);
        List<Attribute> onEvents = this.getAttributes(componentNode, _EVENTS, _EVENT);
        ArrayList<Attribute> prefixedEvents = new ArrayList<Attribute>();
        for (Attribute event : afterEvents) {
            name = _AFTER.concat(StringUtils.capitalize((String)event.getSafeName()));
            event.setName(name);
            prefixedEvents.add(event);
        }
        for (Attribute event : onEvents) {
            name = _ON.concat(StringUtils.capitalize((String)event.getSafeName()));
            event.setName(name);
            prefixedEvents.add(event);
        }
        return prefixedEvents;
    }

    protected Map<String, Object> getTemplateContext(Component component) {
        Map<String, Object> context = this.getDefaultTemplateContext();
        String jspRelativePath = this.getJspDir(component).concat(component.getUncamelizedName("_"));
        context.put(_COMPONENT, component);
        context.put("namespace", component.getAttributeNamespace());
        context.put("jspRelativePath", jspRelativePath);
        return context;
    }

    protected Document mergeTlds(Document sourceDoc, Document targetDoc) {
        Element targetRoot = targetDoc.getRootElement();
        XPath xpathTags = SAXReaderUtil.createXPath((String)"//tld:tag", (String)_TLD_XPATH_PREFIX, (String)_TLD_XPATH_URI);
        List sources = xpathTags.selectNodes((Object)sourceDoc);
        for (Node source : sources) {
            Element sourceElement = (Element)source;
            String sourceName = sourceElement.elementText("name");
            String xpathTagValue = "//tld:tag[tld:name='" + sourceName + "']";
            XPath xpathTag = SAXReaderUtil.createXPath((String)xpathTagValue, (String)_TLD_XPATH_PREFIX, (String)_TLD_XPATH_URI);
            List targets = xpathTag.selectNodes((Object)targetDoc);
            if (targets.size() > 0) {
                Element targetElement = (Element)targets.get(0);
                XPath xpathAttributes = SAXReaderUtil.createXPath((String)(xpathTagValue + "//tld:attribute"), (String)_TLD_XPATH_PREFIX, (String)_TLD_XPATH_URI);
                List sourceAttributes = xpathAttributes.selectNodes((Object)source);
                for (Node sourceAttribute : sourceAttributes) {
                    Element sourceAttributeElement = (Element)sourceAttribute;
                    String attributeName = sourceAttributeElement.elementText("name");
                    String xpathAttributeValue = "//tld:attribute[tld:name='" + attributeName + "']";
                    XPath xpathAttribute = SAXReaderUtil.createXPath((String)(xpathTagValue + xpathAttributeValue), (String)_TLD_XPATH_PREFIX, (String)_TLD_XPATH_URI);
                    Node targetAttribute = xpathAttribute.selectSingleNode((Object)targetElement);
                    if (targetAttribute != null) {
                        targetAttribute.detach();
                    }
                    targetElement.add(sourceAttributeElement.createCopy());
                }
                Element dynamicAttrElement = targetElement.element("dynamic-attributes");
                if (dynamicAttrElement == null) continue;
                targetElement.add(dynamicAttrElement.detach());
                continue;
            }
            targetRoot.add(sourceElement.createCopy());
        }
        return targetDoc;
    }

    protected Document mergeXMLAttributes(Document doc1, Document doc2) {
        Element doc1Root = doc1.getRootElement();
        Element docRoot = doc1Root.createCopy();
        docRoot.clearContent();
        Document doc = SAXReaderUtil.createDocument();
        doc.setRootElement(docRoot);
        List doc1Components = doc1Root.elements(_COMPONENT);
        for (Element doc1Component : doc1Components) {
            String name = doc1Component.attributeValue("name");
            Element doc2Component = this.getComponentNode(doc2, name);
            if (doc2Component != null) {
                Element doc2EventsNode;
                Element doc2AttributesNode = doc2Component.element(_ATTRIBUTES);
                if (doc2AttributesNode != null) {
                    List doc2Attributes = doc2AttributesNode.elements(_ATTRIBUTE);
                    Element doc1AttributesNode = doc1Component.element(_ATTRIBUTES);
                    for (Element doc2Attribute : doc2Attributes) {
                        Element doc1Attribute = this.getElementByName(doc1AttributesNode.elements(_ATTRIBUTE), doc2Attribute.elementText("name"));
                        if (doc1Attribute != null) continue;
                        doc1AttributesNode.add(doc2Attribute.createCopy());
                    }
                }
                if ((doc2EventsNode = doc2Component.element(_EVENTS)) != null) {
                    List doc2Events = doc2EventsNode.elements(_EVENT);
                    Element doc1EventsNode = doc1Component.element(_EVENTS);
                    for (Element doc2Event : doc2Events) {
                        Element doc1Event = this.getElementByName(doc1EventsNode.elements(_EVENT), doc2Event.elementText("name"));
                        if (doc1Event != null) continue;
                        doc1EventsNode.add(doc2Event.createCopy());
                    }
                }
            }
            doc.getRootElement().add(doc1Component.createCopy());
        }
        return doc;
    }

    protected String processTemplate(String name, Map<String, Object> context) throws Exception {
        return StringUtil.replace((String)FreeMarkerUtil.process((String)name, context), (char)'\r', (String)"");
    }

    protected void writeFile(File file, String content) {
        this.writeFile(file, content, true);
    }

    protected void writeFile(File file, String content, boolean overwrite) {
        if (FileUtil.getFile() == null) {
            new FileUtil().setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        }
        try {
            if (overwrite || !file.exists()) {
                String oldContent = "";
                if (file.exists()) {
                    oldContent = FileUtil.read((File)file);
                }
                if (!file.exists() || !content.equals(oldContent)) {
                    System.out.println("Writing " + file);
                    FileUtil.write((File)file, (String)content);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void _create() throws Exception {
        List<Component> components = this.getAllComponents();
        for (Component component : components) {
            Map<String, Object> context = this.getTemplateContext(component);
            this._createBaseTag(component, context);
            if (component.getWriteJSP()) {
                this._createPageJSP(component, context);
            }
            this._createTag(component, context);
        }
        this._createCommonInitJSP();
        this._createTld();
        this._createServletContextUtil();
    }

    private void _createBaseTag(Component component, Map<String, Object> context) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaOutputBaseDir(component));
        sb.append(_BASE_CLASS_PREFIX);
        sb.append(component.getClassName());
        sb.append(_CLASS_SUFFIX);
        String content = this.processTemplate(this._tplTagBase, context);
        File tagFile = new File(sb.toString());
        this.writeFile(tagFile, content);
    }

    private void _createCommonInitJSP() throws Exception {
        Map<String, Object> context = this.getDefaultTemplateContext();
        String contentCommonInitJsp = this.processTemplate(this._tplCommonInitJsp, context);
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull((String)this._jspParentDir)) {
            sb.append(this._jspParentDir);
            sb.append("/");
        }
        sb.append(this._jspCommonInitPath);
        File commonInitFile = new File(sb.toString());
        this.writeFile(commonInitFile, contentCommonInitJsp, false);
    }

    private void _createPageJSP(Component component, Map<String, Object> context) throws Exception {
        String pathName = component.getUncamelizedName("_");
        String path = this.getJspOutputDir(component).concat(pathName);
        String contentJsp = this.processTemplate(this._tplJsp, context);
        String contentInitJsp = this.processTemplate(this._tplInitJsp, context);
        File initFile = new File(path.concat(_INIT_PAGE));
        File initExtFile = new File(path.concat(_INIT_EXT_PAGE));
        this.writeFile(initFile, contentInitJsp);
        this.writeFile(initExtFile, "", false);
        if (component.isBodyContent()) {
            if (component.getWriteStartJSP()) {
                String contentStart = this.processTemplate(this._tplStartJsp, context);
                File startFile = new File(path.concat(_START_PAGE));
                this.writeFile(startFile, contentStart, false);
            }
            if (component.getWriteEndJSP()) {
                String contentEnd = this.processTemplate(this._tplEndJsp, context);
                File endFile = new File(path.concat(_END_PAGE));
                this.writeFile(endFile, contentEnd, false);
            }
        } else {
            File pageFile = new File(path.concat(_PAGE));
            this.writeFile(pageFile, contentJsp, false);
        }
    }

    private void _createServletContextUtil() throws Exception {
        for (Document doc : this._componentsExtDoc) {
            Element root = doc.getRootElement();
            boolean OSGIModule = GetterUtil.getBoolean((String)root.attributeValue("osgi-module"));
            if (!OSGIModule) continue;
            Map<String, Object> context = this.getDefaultTemplateContext();
            String OSGIModuleSymbolicName = GetterUtil.get((String)this._OSGIModuleSymbolicName, (String)"");
            context.put("OSGIModuleSymbolicName", OSGIModuleSymbolicName);
            context.put("taglibAuthors", this.getAuthorList(root));
            StringBuilder sb = new StringBuilder();
            sb.append(this._javaDir);
            sb.append(_SERVLET_CONTEXT_UTIL);
            sb.append(_CLASS_SUFFIX);
            String content = this.processTemplate(this._tplServletContextUtil, context);
            File servletContextUtilFile = new File(sb.toString());
            this.writeFile(servletContextUtilFile, content, false);
            if (!servletContextUtilFile.exists()) continue;
            break;
        }
    }

    private void _createTag(Component component, Map<String, Object> context) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaOutputDir(component));
        sb.append(component.getClassName());
        sb.append(_CLASS_SUFFIX);
        String content = this.processTemplate(this._tplTag, context);
        File tagFile = new File(sb.toString());
        this.writeFile(tagFile, content, false);
    }

    private void _createTld() throws Exception {
        Map<String, Object> context = this.getDefaultTemplateContext();
        for (Document doc : this._componentsExtDoc) {
            Element root = doc.getRootElement();
            String description = GetterUtil.getString((String)root.elementText("description"), (String)"");
            String shortName = GetterUtil.getString((String)root.attributeValue("short-name"), (String)"alloy");
            String uri = GetterUtil.getString((String)root.attributeValue("uri"), (String)_DEFAULT_TAGLIB_URI);
            String version = GetterUtil.getString((String)root.attributeValue("tlib-version"), (String)_DEFAULT_TAGLIB_VERSION);
            context.put("alloyComponent", shortName.equals("alloy"));
            context.put("description", description);
            context.put("shortName", shortName);
            context.put("uri", uri);
            context.put("version", version);
            context.put("components", this.getComponents(doc));
            String tldFilePath = this._tldDir.concat(this.getTldFileName(shortName)).concat(_TLD_EXTENSION);
            File tldFile = new File(tldFilePath);
            String content = this.processTemplate(this._tplTld, context);
            Document source = SAXReaderUtil.read((String)content);
            if (tldFile.exists()) {
                Document target = SAXReaderUtil.read((File)tldFile);
                source = this.mergeTlds(source, target);
            }
            this.writeFile(tldFile, source.formattedString());
        }
    }

    private String getTldFileName(String tldFileName) {
        if (tldFileName.equals(_AUI)) {
            tldFileName = "liferay-" + tldFileName;
            return tldFileName;
        }
        return tldFileName;
    }
}

