/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.dao.jdbc;

import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.dao.jdbc.PACLStatementHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;

public class PACLConnectionHandler
implements InvocationHandler {
    private final Connection _connection;
    private final PACLPolicy _paclPolicy;

    public PACLConnectionHandler(Connection connection, PACLPolicy paclPolicy) {
        this._connection = connection;
        this._paclPolicy = paclPolicy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String sql;
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (proxy == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if ((methodName.equals("prepareCall") || methodName.equals("prepareStatement")) && !this._paclPolicy.hasSQL(sql = (String)arguments[0])) {
                throw new SecurityException("Attempted to execute unapproved SQL " + sql);
            }
            Object returnValue = method.invoke((Object)this._connection, arguments);
            if (methodName.equals("createStatement") || methodName.equals("prepareCall") || methodName.equals("prepareStatement")) {
                Statement statement = (Statement)returnValue;
                statement = (Statement)DoPrivilegedFactory.wrap((Object)statement);
                return AccessController.doPrivileged(new StatementPrivilegedAction(statement, returnValue));
            }
            return returnValue;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Class<?>[] getInterfaces(Class<?> returnType) {
        ArrayList<Class<PreparedStatement>> interfaceClasses = new ArrayList<Class<PreparedStatement>>();
        interfaceClasses.add(Statement.class);
        if (!CallableStatement.class.isAssignableFrom(returnType)) {
            interfaceClasses.add(CallableStatement.class);
        } else if (!PreparedStatement.class.isAssignableFrom(returnType)) {
            interfaceClasses.add(PreparedStatement.class);
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }

    private class StatementPrivilegedAction
    implements PrivilegedAction<Statement> {
        private final Object _returnValue;
        private final Statement _statement;

        public StatementPrivilegedAction(Statement statement, Object returnValue) {
            this._statement = statement;
            this._returnValue = returnValue;
        }

        @Override
        public Statement run() {
            return (Statement)ProxyUtil.newProxyInstance((ClassLoader)PACLConnectionHandler.this._paclPolicy.getClassLoader(), (Class[])PACLConnectionHandler.this.getInterfaces(this._returnValue.getClass()), (InvocationHandler)new PACLStatementHandler(this._statement, PACLConnectionHandler.this._paclPolicy));
        }
    }
}

