/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.Permissions;

public class SocketChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(SocketChecker.class);
    private final Permissions _permissions = new Permissions();

    @Override
    public void afterPropertiesSet() {
        this.initAcceptHostsAndPorts();
        this.initConnectHostsAndPorts();
        this.initListenPorts();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String actions = permission.getActions();
        if (actions.equals("resolve")) {
            return null;
        }
        String name = permission.getName();
        int index = name.indexOf(":");
        int port = GetterUtil.getInteger((String)name.substring(index + 1));
        String key = null;
        String value = null;
        if (actions.contains("accept")) {
            key = "security-manager-sockets-accept";
            value = name;
        } else if (actions.contains("connect")) {
            key = "security-manager-sockets-connect";
            value = name;
        } else if (actions.contains("listen")) {
            key = "security-manager-sockets-listen";
            value = String.valueOf(port);
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        String actions = permission.getActions();
        String name = permission.getName();
        if (!this._permissions.implies(permission)) {
            this.logSecurityException(_log, "Attempted " + actions + " for address " + name);
            return false;
        }
        return true;
    }

    protected void initAcceptHostsAndPorts() {
        String[] networkParts;
        for (String networkPart : networkParts = this.getPropertyArray("security-manager-sockets-accept")) {
            this.initHostsAndPorts(networkPart, "accept");
        }
    }

    protected void initConnectHostsAndPorts() {
        String[] networkParts;
        for (String networkPart : networkParts = this.getPropertyArray("security-manager-sockets-connect")) {
            this.initHostsAndPorts(networkPart, "connect");
        }
    }

    protected void initHostsAndPorts(String networkPart, String action) {
        SocketPermission socketPermission = new SocketPermission(networkPart, action);
        this._permissions.add(socketPermission);
    }

    protected void initListenPorts() {
        String[] listenParts;
        for (String listenPart : listenParts = this.getPropertyArray("security-manager-sockets-listen")) {
            this.initListenPorts(listenPart);
        }
    }

    protected void initListenPorts(String listenPart) {
        this.initHostsAndPorts("*:" + listenPart, "listen");
    }
}

