/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(RuntimeChecker.class);
    private boolean _accessDeclaredMembers;
    private boolean _createClassLoader;
    private List<Pattern> _environmentVariablePatterns;
    private boolean _getProtectionDomain;
    private boolean _modifyThread;
    private boolean _setContextClassLoader;

    @Override
    public void afterPropertiesSet() {
        this.initAccessDeclaredMembers();
        this.initCreateClassLoader();
        this.initEnvironmentVariables();
        this.initGetProtectionDomain();
        this.initModifyThread();
        this.initSetContextClassLoader();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String name = permission.getName();
        String key = null;
        String value = null;
        if (name.startsWith("accessDeclaredMembers")) {
            key = "security-manager-access-declared-members";
            value = "true";
        } else if (name.startsWith("createClassLoader")) {
            key = "security-manager-create-class-loader";
            value = "true";
        } else if (name.startsWith("getenv")) {
            key = "security-manager-environment-variables";
            value = name.substring("getenv".length() + 1);
            if (value.equals("*")) {
                value = "\\\\" + value;
            }
        } else if (name.startsWith("getProtectionDomain")) {
            key = "security-manager-get-protection-domain";
            value = "true";
        } else if (name.equals("modifyThread")) {
            key = "security-manager-modify-thread";
            value = "true";
        } else if (name.equals("setContextClassLoader")) {
            key = "security-manager-set-context-class-loader";
            value = "true";
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        String name = permission.getName();
        if (name.startsWith("accessClassInPackage")) {
            int pos = name.indexOf(".");
            String pkg = name.substring(pos + 1);
            if (!this.hasAccessClassInPackage(pkg)) {
                this.logSecurityException(_log, "Attempted to access package " + pkg);
                return false;
            }
        } else if (name.equals("accessDeclaredMembers")) {
            if (!this.hasAccessDeclaredMembers(permission)) {
                this.logSecurityException(_log, "Attempted to access declared members");
                return false;
            }
        } else if (name.equals("createClassLoader")) {
            if (!this.hasCreateClassLoader(permission)) {
                this.logSecurityException(_log, "Attempted to create a class loader");
                return false;
            }
        } else if (name.equals("createSecurityManager")) {
            if (!this.hasCreateSecurityManager(permission)) {
                this.logSecurityException(_log, "Attempted to create a security manager");
                return false;
            }
        } else if (name.startsWith("getClassLoader")) {
            if (!this.hasGetClassLoader(permission)) {
                this.logSecurityException(_log, "Attempted to get class loader");
                return false;
            }
        } else if (name.startsWith("getProtectionDomain")) {
            if (!this.hasGetProtectionDomain(permission)) {
                this.logSecurityException(_log, "Attempted to get protection domain");
                return false;
            }
        } else if (name.startsWith("getenv")) {
            int pos = name.indexOf(".");
            String envName = name.substring(pos + 1);
            if (!this.hasGetEnv(envName, permission)) {
                this.logSecurityException(_log, "Attempted to get environment name " + envName);
                return false;
            }
        } else if (name.startsWith("loadLibrary")) {
            if (!this.hasLoadLibrary(permission)) {
                this.logSecurityException(_log, "Attempted to load library");
                return false;
            }
        } else if (name.equals("modifyThread")) {
            if (!this.hasModifyThread(permission)) {
                this.logSecurityException(_log, "Attempted to modify a thread");
                return false;
            }
        } else if (name.equals("readFileDescriptor")) {
            if (!this.hasReadFileDescriptor(permission)) {
                this.logSecurityException(_log, "Attempted to read file descriptor");
                return false;
            }
        } else if (name.equals("setContextClassLoader")) {
            if (!this.hasSetContextClassLoader(permission)) {
                this.logSecurityException(_log, "Attempted to set the context class loader");
                return false;
            }
        } else {
            if (name.equals("setSecurityManager")) {
                this.logSecurityException(_log, "Attempted to set another security manager");
                return false;
            }
            if (name.equals("writeFileDescriptor")) {
                if (!this.hasWriteFileDescriptor(permission)) {
                    this.logSecurityException(_log, "Attempted to write file descriptor");
                    return false;
                }
            } else {
                if (_log.isDebugEnabled()) {
                    Thread.dumpStack();
                }
                this.logSecurityException(_log, "Attempted to " + permission.getName() + " on " + permission.getActions());
                return false;
            }
        }
        return true;
    }

    protected boolean hasAccessClassInPackage(String pkg) {
        if (pkg.startsWith("sun.reflect")) {
            // empty if block
        }
        return true;
    }

    protected boolean hasAccessDeclaredMembers(Permission permission) {
        if (this._accessDeclaredMembers) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(6, 5);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasCreateClassLoader(Permission permission) {
        if (this._createClassLoader) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(8, 4);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasCreateSecurityManager(Permission permission) {
        int stackIndex = Reflection.getStackIndex(4, 3);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasGetClassLoader(Permission permission) {
        int stackIndex = Reflection.getStackIndex(new int[]{5, 5, 6}, new int[]{4, 4, 4});
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasGetEnv(String name, Permission permission) {
        for (Pattern environmentVariablePattern : this._environmentVariablePatterns) {
            Matcher matcher = environmentVariablePattern.matcher(name);
            if (!matcher.matches()) continue;
            return true;
        }
        int stackIndex = Reflection.getStackIndex(4, 3);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasGetProtectionDomain(Permission permission) {
        if (this._getProtectionDomain) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(4, 3);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasLoadLibrary(Permission permission) {
        int stackIndex = Reflection.getStackIndex(6, 5);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasModifyThread(Permission permission) {
        if (this._modifyThread) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(6, 5);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasReadFileDescriptor(Permission permission) {
        int stackIndex = Reflection.getStackIndex(5, 4);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasSetContextClassLoader(Permission permission) {
        if (this._setContextClassLoader) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(4, 3);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected boolean hasWriteFileDescriptor(Permission permission) {
        int stackIndex = Reflection.getStackIndex(5, 4);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        return this.isTrustedCaller(callerClass, permission);
    }

    protected void initAccessDeclaredMembers() {
        this._accessDeclaredMembers = this.getPropertyBoolean("security-manager-access-declared-members");
    }

    protected void initCreateClassLoader() {
        this._createClassLoader = this.getPropertyBoolean("security-manager-create-class-loader");
    }

    protected void initEnvironmentVariables() {
        Set<String> environmentVariables = this.getPropertySet("security-manager-environment-variables");
        this._environmentVariablePatterns = new ArrayList<Pattern>(environmentVariables.size());
        for (String environmentVariable : environmentVariables) {
            Pattern environmentVariablePattern = Pattern.compile(environmentVariable);
            this._environmentVariablePatterns.add(environmentVariablePattern);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Allowing access to environment variables that match the regular expression " + environmentVariable));
        }
    }

    protected void initGetProtectionDomain() {
        this._getProtectionDomain = this.getPropertyBoolean("security-manager-get-protection-domain");
    }

    protected void initModifyThread() {
        this._modifyThread = this.getPropertyBoolean("security-manager-modify-thread");
    }

    protected void initSetContextClassLoader() {
        this._setContextClassLoader = this.getPropertyBoolean("security-manager-set-context-class-loader");
    }
}

