/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PortalServiceChecker
extends BaseChecker {
    private static final String _PORTAL_SERVLET_CONTEXT_NAME = "portal";
    private final Map<String, Set<String>> _pluginServices = new HashMap<String, Set<String>>();
    private Set<String> _portalServices = Collections.emptySet();

    @Override
    public void afterPropertiesSet() {
        this.initServices();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        StringBundler sb = new StringBundler(4);
        sb.append("security-manager-services");
        sb.append("[");
        PortalServicePermission portalServicePermission = (PortalServicePermission)arguments[0];
        sb.append(portalServicePermission.getServletContextName());
        sb.append("]");
        authorizationProperty.setKey(sb.toString());
        authorizationProperty.setValue(portalServicePermission.getClassName() + "#" + portalServicePermission.getMethodName());
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        PortalServicePermission portalServicePermission = (PortalServicePermission)permission;
        String name = portalServicePermission.getShortName();
        return !name.equals("service") || this.hasService(portalServicePermission.getServletContextName(), portalServicePermission.getClassName(), portalServicePermission.getMethodName(), permission);
    }

    protected Set<String> getServices(String servletContextName) {
        Set<String> services = null;
        if (servletContextName.equals(_PORTAL_SERVLET_CONTEXT_NAME)) {
            services = this._portalServices;
        } else {
            services = this._pluginServices.get(servletContextName);
            if (services == null) {
                return Collections.emptySet();
            }
        }
        return services;
    }

    protected boolean hasService(String servletContextName, String className, String methodName, Permission permission) {
        int stackIndex = Reflection.getStackIndex(8, 7);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        if (this.isTrustedCaller(callerClass, permission) && this.isTrustedCaller(callerClass = Reflection.getCallerClass(stackIndex + 1), permission)) {
            return true;
        }
        Set<String> services = this.getServices(servletContextName);
        if (services.contains(className)) {
            return true;
        }
        if (Validator.isNull((String)methodName)) {
            return false;
        }
        return services.contains(className.concat("#").concat(methodName));
    }

    protected void initServices() {
        Properties properties = this.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("security-manager-services[")) continue;
            int x = key.indexOf("[");
            int y = key.indexOf("]", x);
            String servicesServletContextName = key.substring(x + 1, y);
            Set services = SetUtil.fromArray((Object[])StringUtil.split((String)value));
            if (servicesServletContextName.equals(_PORTAL_SERVLET_CONTEXT_NAME)) {
                this._portalServices = services;
                continue;
            }
            this._pluginServices.put(servicesServletContextName, services);
        }
    }
}

