/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalHookPermission;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class PortalHookChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(PortalHookChecker.class);
    private boolean _customJspDir;
    private Set<String> _indexers;
    private Set<String> _languagePropertiesLanguageIds;
    private Set<String> _portalPropertiesKeys;
    private Set<String> _services;
    private boolean _servletFilters;
    private Set<String> _strutsActionPaths;

    @Override
    public void afterPropertiesSet() {
        this.initCustomJspDir();
        this.initIndexers();
        this.initLanguagePropertiesLocales();
        this.initPortalPropertiesKeys();
        this.initServletFilters();
        this.initServices();
        this.initStrutsActionPaths();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        PortalHookPermission portalHookPermission = (PortalHookPermission)arguments[0];
        String name = portalHookPermission.getName();
        Object subject = portalHookPermission.getSubject();
        String key = null;
        String value = null;
        if (name.equals("customJspDir")) {
            key = "security-manager-hook-custom-jsp-dir-enabled";
            value = "true";
        } else if (name.equals("hasIndexer")) {
            key = "security-manager-hook-indexers";
            value = (String)subject;
        } else if (name.equals("languagePropertiesLocale")) {
            key = "security-manager-hook-language-properties-locales";
            Locale locale = (Locale)subject;
            value = LocaleUtil.toLanguageId((Locale)locale);
        } else if (name.equals("hasPortalPropertiesKey")) {
            key = "security-manager-hook-portal-properties-keys";
            value = (String)subject;
        } else if (name.equals("service")) {
            key = "security-manager-hook-services";
            value = (String)subject;
        } else if (name.equals("servletFilters")) {
            key = "security-manager-hook-servlet-filters-enabled";
            value = "true";
        } else if (name.equals("strutsActionPath")) {
            key = "security-manager-hook-struts-action-paths";
            value = (String)subject;
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        String strutsActionPath;
        PortalHookPermission portalHookPermission = (PortalHookPermission)permission;
        String name = portalHookPermission.getName();
        Object subject = portalHookPermission.getSubject();
        if (name.equals("customJspDir")) {
            if (!this._customJspDir) {
                this.logSecurityException(_log, "Attempted to set custom jsp dir");
                return false;
            }
        } else if (name.equals("hasIndexer")) {
            String indexerClassName = (String)subject;
            if (!this._indexers.contains(indexerClassName)) {
                this.logSecurityException(_log, "Attempted to add indexer " + indexerClassName);
                return false;
            }
        } else if (name.equals("languagePropertiesLocale")) {
            Locale locale = (Locale)subject;
            if (!this._languagePropertiesLanguageIds.contains(locale.getLanguage()) && !this._languagePropertiesLanguageIds.contains(locale.getLanguage() + "_" + locale.getCountry())) {
                this.logSecurityException(_log, "Attempted to override locale " + locale);
                return false;
            }
        } else if (name.equals("hasPortalPropertiesKey")) {
            String key = (String)subject;
            if (!this._portalPropertiesKeys.contains(key)) {
                this.logSecurityException(_log, "Attempted to set portal property " + key);
                return false;
            }
        } else if (name.equals("service")) {
            String serviceType = (String)subject;
            if (!this._services.contains(serviceType)) {
                this.logSecurityException(_log, "Attempted to override service " + serviceType);
                return false;
            }
        } else if (name.equals("servletFilters")) {
            if (!this._servletFilters) {
                this.logSecurityException(_log, "Attempted to override serlvet filters");
                return false;
            }
        } else if (name.equals("strutsActionPath") && !this._strutsActionPaths.contains(strutsActionPath = (String)subject)) {
            this.logSecurityException(_log, "Attempted to use struts action path " + strutsActionPath);
            return false;
        }
        return true;
    }

    protected void initCustomJspDir() {
        this._customJspDir = this.getPropertyBoolean("security-manager-hook-custom-jsp-dir-enabled");
        if (_log.isDebugEnabled() && this._customJspDir) {
            _log.debug((Object)"Allowing custom JSP dir");
        }
    }

    protected void initIndexers() {
        this._indexers = this.getPropertySet("security-manager-hook-indexers");
        if (_log.isDebugEnabled()) {
            TreeSet<String> indexers = new TreeSet<String>(this._indexers);
            for (String indexer : indexers) {
                _log.debug((Object)("Allowing indexer " + indexer));
            }
        }
    }

    protected void initLanguagePropertiesLocales() {
        this._languagePropertiesLanguageIds = this.getPropertySet("security-manager-hook-language-properties-locales");
        if (_log.isDebugEnabled()) {
            TreeSet<String> languageIds = new TreeSet<String>(this._languagePropertiesLanguageIds);
            for (String languageId : languageIds) {
                _log.debug((Object)("Allowing locale " + languageId));
            }
        }
    }

    protected void initPortalPropertiesKeys() {
        this._portalPropertiesKeys = this.getPropertySet("security-manager-hook-portal-properties-keys");
        if (_log.isDebugEnabled()) {
            TreeSet<String> keys = new TreeSet<String>(this._portalPropertiesKeys);
            for (String key : keys) {
                _log.debug((Object)("Allowing portal.properties key " + key));
            }
        }
    }

    protected void initServices() {
        this._services = this.getPropertySet("security-manager-hook-services");
        if (_log.isDebugEnabled()) {
            TreeSet<String> services = new TreeSet<String>(this._services);
            for (String service : services) {
                _log.debug((Object)("Allowing service " + service));
            }
        }
    }

    protected void initServletFilters() {
        this._servletFilters = this.getPropertyBoolean("security-manager-hook-servlet-filters-enabled");
        if (_log.isDebugEnabled() && this._servletFilters) {
            _log.debug((Object)"Allowing servlet filters");
        }
    }

    protected void initStrutsActionPaths() {
        this._strutsActionPaths = this.getPropertySet("security-manager-hook-struts-action-paths");
        if (_log.isDebugEnabled()) {
            TreeSet<String> strutsActionPaths = new TreeSet<String>(this._strutsActionPaths);
            for (String strutsActionPath : strutsActionPaths) {
                _log.debug((Object)("Allowing Struts action path " + strutsActionPath));
            }
        }
    }
}

