/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import javax.management.MBeanPermission;
import javax.management.MBeanTrustPermission;

public class MBeanChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(MBeanChecker.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public boolean implies(Permission permission) {
        String name = permission.getName();
        String actions = permission.getActions();
        if (permission instanceof MBeanPermission && (actions.equals("isInstanceOf") || actions.equals("registerMBean") || actions.equals("unregisterMBean"))) {
            return true;
        }
        if (permission instanceof MBeanTrustPermission && name.equals("register")) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to perform MBean operation " + permission);
        return false;
    }
}

