/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JNDIChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(JNDIChecker.class);
    private List<Pattern> _patterns;

    @Override
    public void afterPropertiesSet() {
        this.initNames();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof String)) {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey("security-manager-jndi-names");
        authorizationProperty.setValue((String)arguments[0]);
        return authorizationProperty;
    }

    public boolean hasJNDI(String name) {
        for (Pattern pattern : this._patterns) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean implies(Permission permission) {
        throw new UnsupportedOperationException();
    }

    protected void initNames() {
        Set<String> names = this.getPropertySet("security-manager-jndi-names");
        this._patterns = new ArrayList<Pattern>(names.size());
        for (String name : names) {
            Pattern pattern = Pattern.compile(name);
            this._patterns.add(pattern);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Allowing access to JNDI names that match the regular expression " + name));
        }
    }
}

