/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.url.URLContainer;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;

public class FileChecker
extends BaseChecker {
    private static final String _ENV_PREFIX = "${env:";
    private static final String _GLOBAL_SHARED_LIB_DIR = PropsValues.LIFERAY_LIB_GLOBAL_SHARED_DIR;
    private static final String _PORTAL_DIR = PropsValues.LIFERAY_WEB_PORTAL_DIR;
    private static final Log _log = LogFactoryUtil.getLog(FileChecker.class);
    private String[] _defaultReadPathsFromArray;
    private String[] _defaultReadPathsToArray;
    private final Permissions _permissions = new Permissions();
    private String _rootDir;
    private String _workDir;

    @Override
    public void afterPropertiesSet() {
        Properties properties;
        PACLPolicy paclPolicy = this.getPACLPolicy();
        URLContainer urlContainer = paclPolicy.getURLContainer();
        try {
            URL url = urlContainer.getResource("/");
            this._rootDir = url.getPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Root directory " + this._rootDir));
        }
        if ((properties = paclPolicy.getProperties()).containsKey("javax.servlet.context.tempdir")) {
            this._workDir = paclPolicy.getProperty("javax.servlet.context.tempdir");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Work directory " + this._workDir));
            }
        }
        this._defaultReadPathsFromArray = new String[]{"${/}", "${auto.deploy.installed.dir}", "${catalina.base}", "${com.sun.aas.instanceRoot}", "${com.sun.aas.installRoot}", "${file.separator}", "${java.home}", "${java.io.tmpdir}", "${jboss.home.dir}", "${jetty.home}", "${jonas.base}", "${liferay.web.portal.dir}", "${liferay.home}", "${line.separator}", "${path.separator}", "${plugin.servlet.context.name}", "${release.info.version}", "${resin.home}", "${user.dir}", "${user.home}", "${user.name}", "${weblogic.domain.dir}", "${websphere.cell}", "${websphere.profile.dir}", "//"};
        String installedDir = "";
        try {
            if (DeployManagerUtil.getDeployManager() != null) {
                installedDir = DeployManagerUtil.getInstalledDir();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._defaultReadPathsToArray = new String[]{System.getProperty("file.separator"), installedDir, System.getProperty("catalina.base"), System.getProperty("com.sun.aas.instanceRoot"), System.getProperty("com.sun.aas.installRoot"), System.getProperty("file.separator"), System.getProperty("java.home"), System.getProperty("java.io.tmpdir"), System.getProperty("jboss.home.dir"), System.getProperty("jetty.home"), System.getProperty("jonas.base"), _PORTAL_DIR, PropsValues.LIFERAY_HOME, System.getProperty("line.separator"), System.getProperty("path.separator"), this.getContextName(), ReleaseInfo.getVersion(), System.getProperty("resin.home"), System.getProperty("user.dir"), System.getProperty("user.home"), System.getProperty("user.name"), System.getenv("DOMAIN_HOME"), System.getenv("WAS_CELL"), System.getProperty("server.root"), "/"};
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Default read paths replace with " + StringUtil.merge((Object[])this._defaultReadPathsToArray)));
        }
        this.initPermissions();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String actions = permission.getActions();
        String key = null;
        if (actions.equals("delete")) {
            key = "security-manager-files-delete";
        } else if (actions.equals("execute")) {
            key = "security-manager-files-execute";
        } else if (actions.equals("read")) {
            key = "security-manager-files-read";
        } else if (actions.equals("write")) {
            key = "security-manager-files-write";
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(permission.getName());
        return authorizationProperty;
    }

    public String getRootDir() {
        return this._rootDir;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this._permissions.implies(permission)) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to " + permission.getActions() + " on file " + permission.getName());
        return false;
    }

    protected void addCanonicalPath(Set<String> paths, String path) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String curPath = itr.next();
            if (curPath.startsWith(path) && curPath.length() > path.length()) {
                itr.remove();
                continue;
            }
            if (!path.startsWith(curPath)) continue;
            return;
        }
        if ((path = StringUtil.replace((String)path, (char)'\\', (char)'/')).endsWith("/")) {
            path = path + "-";
        }
        paths.add(path);
    }

    protected void addCanonicalPaths(Set<String> paths, File directory) throws IOException {
        this.addCanonicalPath(paths, directory.getCanonicalPath() + "/");
        Object[] files = directory.listFiles();
        if (ArrayUtil.isEmpty((Object[])files)) {
            return;
        }
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                this.addCanonicalPaths(paths, (File)file);
                continue;
            }
            File canonicalFile = new File(((File)file).getCanonicalPath());
            File parentFile = canonicalFile.getParentFile();
            this.addCanonicalPath(paths, parentFile.getPath() + "/");
        }
    }

    protected void addDefaultReadPaths(Set<String> paths, String selector) {
        String[] pathsArray;
        for (String path : pathsArray = PropsUtil.getArray((String)"portal.security.manager.file.checker.default.read.paths", (Filter)new Filter(selector))) {
            path = StringUtil.replace((String)path, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            paths.add(path);
        }
    }

    protected void addPermission(String path, String actions) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Allowing " + actions + " on " + path));
        }
        String unixPath = PathUtil.toUnixPath((String)path);
        FilePermission unixPermission = new FilePermission(unixPath, actions);
        this._permissions.add(unixPermission);
        String windowsPath = PathUtil.toWindowsPath((String)path);
        FilePermission windowsPermission = new FilePermission(windowsPath, actions);
        this._permissions.add(windowsPermission);
    }

    protected void getPermissions(String key, String actions) {
        String[] paths;
        String value = this.getProperty(key);
        if (value != null) {
            int x = value.indexOf(_ENV_PREFIX);
            while (x >= 0) {
                int y = value.indexOf("}", x);
                String propertyName = value.substring(x + 6, y);
                String propertyValue = GetterUtil.getString((String)System.getenv(propertyName));
                String fullPropertyName = _ENV_PREFIX + propertyName + "}";
                if (!ArrayUtil.contains((Object[])this._defaultReadPathsFromArray, (Object)fullPropertyName)) {
                    this._defaultReadPathsFromArray = (String[])ArrayUtil.append((Object[])this._defaultReadPathsFromArray, (Object)fullPropertyName);
                    this._defaultReadPathsToArray = (String[])ArrayUtil.append((Object[])this._defaultReadPathsToArray, (Object)propertyValue);
                }
                x = value.indexOf(_ENV_PREFIX, y + 1);
            }
            value = StringUtil.replace((String)value, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            paths = StringUtil.split((String)value);
            if (value.contains("${comma}")) {
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = StringUtil.replace((String)paths[i], (String)"${comma}", (String)",");
                }
            }
            for (String path : paths) {
                this.addPermission(path, actions);
            }
        }
        ServletContext servletContext = ServletContextPool.get((String)PortalContextLoaderListener.getPortalServletContextName());
        if (!actions.equals("execute") && this._workDir != null) {
            this.addPermission(this._workDir, actions);
            this.addPermission(this._workDir + "/-", actions);
            if (ServerDetector.isWebLogic()) {
                this.addPermission(this._workDir + "/../-", actions);
            }
            if (servletContext != null) {
                File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                String tempDirAbsolutePath = tempDir.getAbsolutePath();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Temp directory " + tempDirAbsolutePath));
                }
                if (actions.equals("read")) {
                    this.addPermission(tempDirAbsolutePath, actions);
                }
                this.addPermission(tempDirAbsolutePath + "/-", actions);
            }
        }
        if (!actions.equals("read")) {
            return;
        }
        paths = new LinkedHashSet();
        try {
            File file = new File(System.getProperty("java.home") + "/lib");
            this.addCanonicalPaths((Set<String>)paths, file);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                String resinHome;
                String jettyHome;
                URL url = enumeration.nextElement();
                URLConnection urlConnection = url.openConnection();
                if (!(urlConnection instanceof JarURLConnection)) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarFileURL = jarURLConnection.getJarFileURL();
                String fileName = jarFileURL.getFile();
                int pos = fileName.lastIndexOf(File.separatorChar);
                if (pos != -1) {
                    fileName = fileName.substring(0, pos + 1);
                }
                if (ServerDetector.isJetty() && fileName.startsWith(jettyHome = System.getProperty("jetty.home")) || ServerDetector.isResin() && fileName.startsWith(resinHome = System.getProperty("resin.home"))) continue;
                this.addCanonicalPath((Set<String>)paths, fileName);
            }
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        if (Validator.isNotNull((String)_GLOBAL_SHARED_LIB_DIR)) {
            paths.add(_GLOBAL_SHARED_LIB_DIR + "-");
        }
        if (this._rootDir != null) {
            paths.add(this._rootDir);
            paths.add(this._rootDir + "-");
        }
        this.addDefaultReadPaths((Set<String>)paths, ServerDetector.getServerId());
        for (String path : paths) {
            this.addPermission(path, actions);
        }
    }

    protected void initPermissions() {
        this.getPermissions("security-manager-files-delete", "delete");
        this.getPermissions("security-manager-files-execute", "execute");
        this.getPermissions("security-manager-files-read", "read");
        this.getPermissions("security-manager-files-write", "write");
    }
}

