/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.security.pacl.PACLConstants;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.Checker;
import java.security.Permission;
import java.util.Properties;
import java.util.Set;

public abstract class BaseChecker
implements Checker,
PACLConstants {
    private PACLPolicy _paclPolicy;

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._paclPolicy.getClassLoader();
    }

    @Override
    public String getContextName() {
        return this._paclPolicy.getContextName();
    }

    @Override
    public PACLPolicy getPACLPolicy() {
        return this._paclPolicy;
    }

    public boolean isTrustedCaller(Class<?> callerClass, Permission permission) {
        return PACLUtil.isTrustedCaller(callerClass, permission, this.getPACLPolicy());
    }

    @Override
    public void setPACLPolicy(PACLPolicy paclPolicy) {
        this._paclPolicy = paclPolicy;
    }

    protected Properties getProperties() {
        return this._paclPolicy.getProperties();
    }

    protected String getProperty(String key) {
        return this._paclPolicy.getProperty(key);
    }

    protected String[] getPropertyArray(String key) {
        return this._paclPolicy.getPropertyArray(key);
    }

    protected boolean getPropertyBoolean(String key) {
        return this._paclPolicy.getPropertyBoolean(key);
    }

    protected Set<String> getPropertySet(String key) {
        return this._paclPolicy.getPropertySet(key);
    }

    protected void logSecurityException(Log log, String message) {
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
    }
}

