/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.awt.AWTPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.Set;

public class AWTChecker
extends BaseChecker {
    private static final Log _log = LogFactoryUtil.getLog(AWTChecker.class);
    private final Permissions _permissions = new Permissions();

    @Override
    public void afterPropertiesSet() {
        this.initOperations();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments != null && arguments.length == 1 && arguments[0] instanceof Permission) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey("security-manager-awt-operations");
        authorizationProperty.setValue(permission.getName());
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this._permissions.implies(permission)) {
            return true;
        }
        String name = permission.getName();
        this.logSecurityException(_log, "Attempted operation " + name + " on AWT");
        return false;
    }

    protected void initOperations() {
        Set<String> names = this.getPropertySet("security-manager-awt-operations");
        for (String name : names) {
            AWTPermission permission = new AWTPermission(name);
            this._permissions.add(permission);
        }
    }
}

