/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.dao.jdbc.DataSourceFactoryImpl;
import com.liferay.portal.dao.orm.hibernate.DynamicQueryFactoryImpl;
import com.liferay.portal.deploy.hot.HotDeployImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.concurrent.ConcurrentIdentityHashMap;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalFilePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalHookPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalMessageBusPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalSocketPermission;
import com.liferay.portal.kernel.url.URLContainer;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReferenceEntry;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WeakValueConcurrentHashMap;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import com.liferay.portal.security.lang.DoPrivilegedHandler;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.security.pacl.ActivePACLPolicy;
import com.liferay.portal.security.pacl.GeneratingPACLPolicy;
import com.liferay.portal.security.pacl.InactivePACLPolicy;
import com.liferay.portal.security.pacl.LenientPermissionCollection;
import com.liferay.portal.security.pacl.PACLAdvice;
import com.liferay.portal.security.pacl.PACLBeanHandler;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLInvocationHandler;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.security.pacl.PACLPolicyThreadLocal;
import com.liferay.portal.security.pacl.PACLUtil;
import com.liferay.portal.security.pacl.PortalPermissionCollection;
import com.liferay.portal.security.pacl.PortalPolicy;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.URLWrapper;
import com.liferay.portal.security.pacl.dao.jdbc.PACLConnectionHandler;
import com.liferay.portal.security.pacl.dao.jdbc.PACLDataSource;
import com.liferay.portal.security.pacl.dao.jdbc.PACLStatementHandler;
import com.liferay.portal.security.pacl.jndi.PACLContext;
import com.liferay.portal.security.pacl.jndi.PACLInitialContextFactory;
import com.liferay.portal.security.pacl.jndi.PACLInitialContextFactoryBuilder;
import com.liferay.portal.security.pacl.jndi.SchemeAwareContextWrapper;
import com.liferay.portal.security.pacl.servlet.PACLRequestDispatcherWrapper;
import com.liferay.portal.service.impl.ServiceComponentLocalServiceImpl;
import com.liferay.portal.servlet.DirectRequestDispatcherFactoryImpl;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portal.spring.bean.BeanReferenceAnnotationBeanPostProcessor;
import com.liferay.portal.spring.bean.BeanReferenceRefreshUtil;
import com.liferay.portal.spring.context.PortletApplicationContext;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateControlContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletURLImpl;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ccpp.Profile;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.osgi.framework.BundleReference;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class PortalSecurityManagerImpl
extends EquinoxSecurityManager
implements PortalSecurityManager {
    private static final Log _log = LogFactoryUtil.getLog((String)PortalSecurityManagerImpl.class.getName());
    private static final ThreadLocal<ClassLoader> _checkMemberAccessClassLoader = new AutoResetThreadLocal(PortalSecurityManagerImpl.class + "._checkMembersAccessClassLoader");
    private static final RuntimePermission _checkMemberAccessPermission = new RuntimePermission("accessDeclaredMembers");
    private final MethodHandle _checkPermissionMethodHandle;
    private SecurityManager _originalSecurityManager;
    private final PortalPolicy _portalPolicy;

    public PortalSecurityManagerImpl() throws IllegalAccessException, NoSuchMethodException, SecurityException {
        block14: {
            block13: {
                PortalPolicy portalPolicy;
                block12: {
                    this._originalSecurityManager = System.getSecurityManager();
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    Class<?> clazz = ((Object)((Object)this)).getClass();
                    clazz = clazz.getSuperclass();
                    Method method = clazz.getDeclaredMethod("internalCheckPermission", Permission.class, Object.class);
                    method.setAccessible(true);
                    MethodHandle methodHandle = lookup.unreflect(method);
                    this._checkPermissionMethodHandle = methodHandle.bindTo((Object)this);
                    this.initClasses();
                    portalPolicy = null;
                    try {
                        Policy policy = null;
                        if (this._originalSecurityManager != null) {
                            policy = Policy.getPolicy();
                        }
                        portalPolicy = new PortalPolicy(policy);
                        Policy.setPolicy(portalPolicy);
                        portalPolicy.refresh();
                    }
                    catch (Exception e) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Unable to override the original Java security policy because sufficient privileges are not granted to Liferay. PACL is not enabled.");
                        }
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)e, (Throwable)e);
                    }
                }
                this._portalPolicy = portalPolicy;
                try {
                    this.initInitialContextFactoryBuilder();
                }
                catch (Exception e) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Unable to override the initial context factory builder because one already exists. JNDI security is not enabled.");
                    }
                    if (!_log.isWarnEnabled()) break block13;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            try {
                this.initPACLImpls();
            }
            catch (Exception e) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Unable to initialize portal runtime permissions. Some portal runtime security is not enabled.");
                }
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        if (ServerDetector.isWebLogic()) {
            this.addWebLogicHook();
        }
        if (ServerDetector.isWebSphere()) {
            this.addWebSphereHook();
        }
    }

    @Deprecated
    public void checkMemberAccess(Class<?> clazz, int accessibility) {
        if (clazz == null) {
            throw new NullPointerException("Class is null");
        }
        ClassLoader clazzClassLoader = ClassLoaderUtil.getClassLoader(clazz);
        if (accessibility == 0 || clazzClassLoader != null && !BundleReference.class.isInstance(clazzClassLoader) && PACLUtil.hasSameOrigin(clazz)) {
            _checkMemberAccessClassLoader.set(clazzClassLoader);
            return;
        }
        Class[] stack = this.getClassContext();
        if (stack.length < 4 || ClassLoaderUtil.getClassLoader((Class)stack[3]) != clazzClassLoader) {
            _checkMemberAccessClassLoader.set(null);
            this.checkPermission(_checkMemberAccessPermission);
        } else {
            _checkMemberAccessClassLoader.set(clazzClassLoader);
        }
    }

    public void checkPermission(Permission permission) {
        String name = permission.getName();
        if (permission instanceof ReflectPermission && name.equals("suppressAccessChecks") && _checkMemberAccessClassLoader.get() != null) {
            Class[] stack = this.getClassContext();
            if (_checkMemberAccessClassLoader.get() == ClassLoaderUtil.getClassLoader((Class)stack[2])) {
                return;
            }
        }
        AccessController.doPrivileged(new PermissionAction(this._checkPermissionMethodHandle, permission, this.getSecurityContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SecurityManager securityManager = this._originalSecurityManager;
        synchronized (securityManager) {
            Policy.setPolicy(this._portalPolicy.getOriginalPolicy());
            System.setSecurityManager(this._originalSecurityManager);
        }
    }

    public Policy getPolicy() {
        return this._portalPolicy;
    }

    protected void addWebLogicHook() {
        PortalSecurityManagerImpl securityManager = this;
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            Runnable runnable = new Runnable((SecurityManager)((Object)securityManager)){
                final /* synthetic */ SecurityManager val$securityManager;
                {
                    this.val$securityManager = securityManager;
                }

                @Override
                public void run() {
                    if (this.val$securityManager != System.getSecurityManager()) {
                        PortalSecurityManagerImpl.this._originalSecurityManager = System.getSecurityManager();
                        System.setSecurityManager(this.val$securityManager);
                    }
                }
            };
            scheduledExecutor.scheduleAtFixedRate(runnable, 100L, 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void addWebSphereHook() {
        try {
            Class.forName("com.liferay.support.websphere.DynamicPolicyHelper");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void initClass(Class<?> clazz) {
        Class<?>[] declaredClasses = clazz.getDeclaredClasses();
        int declaredClassesLength = declaredClasses.length;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + clazz.getName() + " and " + declaredClassesLength + " inner classes"));
        }
    }

    protected void initClasses() {
        this.initClass(((Object)((Object)this)).getClass());
        this.initClass(ActivePACLPolicy.class);
        this.initClass(BaseTemplateManager.class);
        this.initClass(CentralizedThreadLocal.class);
        this.initClass(ConcurrentIdentityHashMap.class);
        this.initClass(ConcurrentReferenceKeyHashMap.class);
        this.initClass(ConcurrentReferenceValueHashMap.class);
        this.initClass(DoPrivilegedBean.class);
        this.initClass(DoPrivilegedFactory.class);
        this.initClass(DoPrivilegedHandler.class);
        this.initClass(DynamicQueryFactoryImpl.class);
        this.initClass(EqualityWeakReference.class);
        this.initClass(FinalizeManager.class);
        this.initClass(GeneratingPACLPolicy.class);
        this.initClass(InactivePACLPolicy.class);
        this.initClass(LenientPermissionCollection.class);
        this.initClass(PACLAdvice.class);
        this.initClass(PACLBeanHandler.class);
        this.initClass(PACLClassLoaderUtil.class);
        this.initClass(PACLClassUtil.class);
        this.initClass(PACLConnectionHandler.class);
        this.initClass(PACLContext.class);
        this.initClass(PACLDataSource.class);
        this.initClass(PACLInvocationHandler.class);
        this.initClass(PACLInitialContextFactory.class);
        this.initClass(PACLInitialContextFactoryBuilder.class);
        this.initClass(PACLPolicyManager.class);
        this.initClass(PACLPolicyThreadLocal.class);
        this.initClass(PACLRequestDispatcherWrapper.class);
        this.initClass(PACLStatementHandler.class);
        this.initClass(PACLUtil.class);
        this.initClass(PortalHookPermission.class);
        this.initClass(PortalMessageBusPermission.class);
        this.initClass(PortalPermissionCollection.class);
        this.initClass(PortalRuntimePermission.class);
        this.initClass(PortalServicePermission.class);
        this.initClass(PortalPolicy.class);
        this.initClass(PortletRequestImpl.class);
        this.initClass(PortletResponseImpl.class);
        this.initClass(PortletURLImpl.class);
        this.initClass(Profile.class);
        this.initClass(Reflection.class);
        this.initClass(SchemeAwareContextWrapper.class);
        this.initClass(TemplateContextHelper.class);
        this.initClass(URLWrapper.class);
        this.initClass(WeakValueConcurrentHashMap.class);
    }

    protected void initInitialContextFactoryBuilder() throws Exception {
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            PACLInitialContextFactoryBuilder paclInitialContextFactoryBuilder = new PACLInitialContextFactoryBuilder();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Overriding the initial context factory builder");
            }
            NamingManager.setInitialContextFactoryBuilder(paclInitialContextFactoryBuilder);
        }
        Class<NamingManager> clazz = NamingManager.class;
        String fieldName = "initctx_factory_builder";
        if (JavaDetector.isIBM()) {
            fieldName = "icfb";
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        InitialContextFactoryBuilder initialContextFactoryBuilder = (InitialContextFactoryBuilder)field.get(null);
        if (initialContextFactoryBuilder instanceof PACLInitialContextFactoryBuilder) {
            return;
        }
        PACLInitialContextFactoryBuilder paclInitialContextFactoryBuilder = new PACLInitialContextFactoryBuilder();
        paclInitialContextFactoryBuilder.setInitialContextFactoryBuilder(initialContextFactoryBuilder);
        field.set(null, paclInitialContextFactoryBuilder);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Overriding the initial context factory builder using reflection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPACLImpl(Class<?> clazz, Object pacl) throws Exception {
        Field field;
        Field field2 = field = ReflectionUtil.getDeclaredField(clazz, (String)"_pacl");
        synchronized (field2) {
            field.setAccessible(true);
            field.set(null, pacl);
        }
    }

    protected void initPACLImpls() throws Exception {
        this.initPACLImpl(BeanLocatorImpl.class, new DoBeanLocatorImplPACL());
        this.initPACLImpl(BeanReferenceRefreshUtil.class, new DoBeanReferenceRefreshUtilPACL());
        this.initPACLImpl(ClassLoaderUtil.class, new DoClassLoaderUtilPACL());
        this.initPACLImpl(DataAccess.class, new DoDataAccessPACL());
        this.initPACLImpl(DataSourceFactoryImpl.class, new DoDataSourceFactoryImplPACL());
        this.initPACLImpl(DirectRequestDispatcherFactoryImpl.class, new DoDirectRequestDispatcherFactoryImplPACL());
        this.initPACLImpl(DoPrivilegedUtil.class, new DoDoPrivilegedPACL());
        this.initPACLImpl(HotDeployImpl.class, new DoHotDeployImplPACL());
        this.initPACLImpl(PortalBeanLocatorUtil.class, new DoPortalBeanLocatorUtilPACL());
        this.initPACLImpl(PortalFilePermission.class, new DoPortalFilePermissionPACL());
        this.initPACLImpl(PortalHookPermission.class, new DoPortalHookPermissionPACL());
        this.initPACLImpl(PortalMessageBusPermission.class, new DoPortalMessageBusPermissionPACL());
        this.initPACLImpl(PortalRuntimePermission.class, new DoPortalRuntimePermissionPACL());
        this.initPACLImpl(PortalServicePermission.class, new DoPortalServicePermissionPACL());
        this.initPACLImpl(PortalSocketPermission.class, new DoPortalSocketPermissionPACL());
        this.initPACLImpl(PortletApplicationContext.class, new DoPortletApplicationContextPACL());
        this.initPACLImpl(ReferenceRegistry.class, new DoReferenceRegistryPACL());
        this.initPACLImpl(ServiceBeanAopProxy.class, new DoServiceBeanAopProxyPACL());
        this.initPACLImpl(ServiceComponentLocalServiceImpl.class, new DoServiceComponentLocalServiceImplPACL());
        this.initPACLImpl(TemplateContextHelper.class, new DoTemplateContextHelperPACL());
    }

    private static class PermissionAction
    implements PrivilegedAction<Void> {
        private final MethodHandle _checkPermissionMethodHandle;
        private final Object _context;
        private final Permission _permission;

        public PermissionAction(MethodHandle checkPermissionMethodHandle, Permission permission, Object context) {
            this._checkPermissionMethodHandle = checkPermissionMethodHandle;
            this._permission = permission;
            this._context = context;
        }

        @Override
        public Void run() {
            try {
                this._checkPermissionMethodHandle.invokeExact(this._permission, this._context);
            }
            catch (Throwable t) {
                ReflectionUtil.throwException((Throwable)t);
            }
            return null;
        }
    }

    private static class DoTemplateContextHelperPACL
    implements TemplateContextHelper.PACL {
        private DoTemplateContextHelperPACL() {
        }

        public TemplateControlContext getTemplateControlContext() {
            PACLPolicy paclPolicy = PACLUtil.getPACLPolicy();
            ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
            if (paclPolicy == null) {
                paclPolicy = PACLPolicyManager.getPACLPolicy(contextClassLoader);
            }
            if (paclPolicy == null || !paclPolicy.isActive()) {
                return new TemplateControlContext(null, contextClassLoader);
            }
            ProtectionDomain protectionDomain = new ProtectionDomain(null, null, paclPolicy.getClassLoader(), null);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return new TemplateControlContext(accessControlContext, paclPolicy.getClassLoader());
        }
    }

    private static class DoServiceComponentLocalServiceImplPACL
    implements ServiceComponentLocalServiceImpl.PACL {
        private DoServiceComponentLocalServiceImplPACL() {
        }

        public void doUpgradeDB(ServiceComponentLocalServiceImpl.DoUpgradeDBPrivilegedExceptionAction doUpgradeDBPrivilegedExceptionAction) throws Exception {
            ProtectionDomain protectionDomain = new ProtectionDomain(null, null, doUpgradeDBPrivilegedExceptionAction.getClassLoader(), null);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            AccessController.doPrivileged(doUpgradeDBPrivilegedExceptionAction, accessControlContext);
        }
    }

    private static class DoServiceBeanAopProxyPACL
    implements ServiceBeanAopProxy.PACL {
        private DoServiceBeanAopProxyPACL() {
        }

        public InvocationHandler getInvocationHandler(InvocationHandler invocationHandler, AdvisedSupport advisedSupport) {
            return new PACLInvocationHandler(invocationHandler, advisedSupport);
        }
    }

    private static class DoReferenceRegistryPACL
    implements ReferenceRegistry.PACL {
        private DoReferenceRegistryPACL() {
        }

        public ReferenceEntry getReferenceEntry(final Class<?> clazz, final Object object, final String fieldName) throws NoSuchFieldException, SecurityException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ReferenceEntry>(){

                    @Override
                    public ReferenceEntry run() throws Exception {
                        Field field = clazz.getDeclaredField(fieldName);
                        return new ReferenceEntry(object, field);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception exception = pae.getException();
                if (exception instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)exception;
                }
                throw (SecurityException)exception;
            }
        }
    }

    private static class DoPortletApplicationContextPACL
    implements PortletApplicationContext.PACL {
        private static final Map<String, Class<?>> _classes = new HashMap();

        private DoPortletApplicationContextPACL() {
        }

        public ClassLoader getBeanClassLoader() {
            return (ClassLoader)DoPrivilegedFactory.wrap((Object)new PreloadClassLoader(PortletClassLoaderUtil.getClassLoader(), _classes));
        }

        static {
            for (String className : PropsValues.PORTAL_SECURITY_MANAGER_PRELOAD_CLASSLOADER_CLASSES) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    _log.error((Object)cnfe, (Throwable)cnfe);
                }
                _classes.put(clazz.getName(), clazz);
            }
        }
    }

    private static class DoPortalSocketPermissionPACL
    implements PortalSocketPermission.PACL {
        private DoPortalSocketPermissionPACL() {
        }

        public void checkPermission(String host, String action) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            SocketPermission permission = new SocketPermission(host, action);
            securityManager.checkPermission(permission);
        }
    }

    private static class DoPortalServicePermissionPACL
    implements PortalServicePermission.PACL {
        private DoPortalServicePermissionPACL() {
        }

        public void checkService(Object object, Method method, Object[] arguments) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            String methodName = method.getName();
            if (methodName.equals("invokeMethod")) {
                methodName = (String)arguments[0];
            }
            Class<?> clazz = PACLUtil.getClass(object);
            String className = PACLUtil.getServiceInterfaceName(clazz.getName());
            ClassLoader classLoader = ClassLoaderUtil.getClassLoader(clazz);
            PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader);
            if (paclPolicy != null && paclPolicy == PACLUtil.getPACLPolicy()) {
                return;
            }
            String contextName = "portal";
            if (paclPolicy != null) {
                contextName = paclPolicy.getContextName();
            }
            PortalServicePermission portalServicePermission = new PortalServicePermission("service", contextName, className, methodName);
            securityManager.checkPermission((Permission)portalServicePermission);
        }
    }

    private static class DoPortalRuntimePermissionPACL
    implements PortalRuntimePermission.PACL {
        private DoPortalRuntimePermissionPACL() {
        }

        public void checkDynamicQuery(Class<?> implClass) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            ClassLoader classLoader = ClassLoaderUtil.getClassLoader(implClass);
            PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader);
            if (paclPolicy == PACLUtil.getPACLPolicy()) {
                return;
            }
            String contextName = "portal";
            if (paclPolicy != null) {
                contextName = paclPolicy.getContextName();
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("getClassLoader", null, contextName);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkExpandoBridge(String className) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("expandoBridge", null, className);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkGetBeanProperty(String servletContextName, Class<?> clazz, String property) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            Class<?> callerClass = Reflection.getCallerClass(5);
            if (clazz == callerClass) {
                return;
            }
            clazz = PACLUtil.getClass(clazz);
            PortalRuntimePermission permission = new PortalRuntimePermission("getBeanProperty", servletContextName, clazz.getName(), property);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkGetClassLoader(String classLoaderReferenceId) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNull((String)classLoaderReferenceId)) {
                classLoaderReferenceId = "portal";
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("getClassLoader", null, classLoaderReferenceId);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkPortletBagPool(String portletId) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("portletBagPool", null, portletId);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkSearchEngine(String searchEngineId) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("searchEngine", null, searchEngineId);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkSetBeanProperty(String servletContextName, Class<?> clazz, String property) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            clazz = PACLUtil.getClass(clazz);
            PortalRuntimePermission permission = new PortalRuntimePermission("setBeanProperty", servletContextName, clazz.getName(), property);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkThreadPoolExecutor(String name) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalRuntimePermission permission = new PortalRuntimePermission("threadPoolExecutor", null, name);
            securityManager.checkPermission((Permission)permission);
        }
    }

    private static class DoPortalMessageBusPermissionPACL
    implements PortalMessageBusPermission.PACL {
        private DoPortalMessageBusPermissionPACL() {
        }

        public void checkListen(String destinationName) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalMessageBusPermission permission = new PortalMessageBusPermission("listen", destinationName);
            securityManager.checkPermission((Permission)permission);
        }

        public void checkSend(String destinationName) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            PortalMessageBusPermission permission = new PortalMessageBusPermission("send", destinationName);
            securityManager.checkPermission((Permission)permission);
        }
    }

    private static class DoPortalHookPermissionPACL
    implements PortalHookPermission.PACL {
        private DoPortalHookPermissionPACL() {
        }

        public void checkPermission(String name, ClassLoader portletClassLoader, Object subject) {
            PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(portletClassLoader);
            if (paclPolicy == null) {
                return;
            }
            PortalHookPermission permission = new PortalHookPermission(name, portletClassLoader, subject);
            if (!paclPolicy.implies((Permission)permission)) {
                throw new SecurityException(permission.toString());
            }
        }
    }

    private static class DoPortalFilePermissionPACL
    implements PortalFilePermission.PACL {
        private DoPortalFilePermissionPACL() {
        }

        public void checkCopy(String source, String destination) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNotNull((String)source)) {
                securityManager.checkRead(source);
            }
            if (Validator.isNull((String)destination)) {
                return;
            }
            securityManager.checkWrite(destination);
        }

        public void checkDelete(String path) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNull((String)path)) {
                return;
            }
            securityManager.checkDelete(path);
        }

        public void checkMove(String source, String destination) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNotNull((String)source)) {
                securityManager.checkRead(source);
                securityManager.checkDelete(source);
            }
            if (Validator.isNull((String)destination)) {
                return;
            }
            securityManager.checkWrite(destination);
            securityManager.checkDelete(destination);
        }

        public void checkRead(String path) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNull((String)path)) {
                return;
            }
            securityManager.checkRead(path);
        }

        public void checkWrite(String path) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return;
            }
            if (Validator.isNull((String)path)) {
                return;
            }
            securityManager.checkWrite(path);
        }
    }

    private static class DoPortalBeanLocatorUtilPACL
    implements PortalBeanLocatorUtil.PACL {
        private DoPortalBeanLocatorUtilPACL() {
        }

        public ClassLoader getBeanLocatorClassLoader(final BeanLocator beanLocator) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return beanLocator.getClassLoader();
                }
            });
        }

        public ClassLoader getContextClassLoader(final Thread currentThread) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return currentThread.getContextClassLoader();
                }
            });
        }

        public void setContextClassLoader(final Thread currentThread, final ClassLoader classLoader) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    currentThread.setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    private static class DoHotDeployImplPACL
    implements HotDeployImpl.PACL {
        private DoHotDeployImplPACL() {
        }

        public void initPolicy(String contextName, URLContainer urlContainer, ClassLoader classLoader, Properties properties) {
            PACLPolicy paclPolicy = PACLPolicyManager.buildPACLPolicy(contextName, urlContainer, classLoader, properties);
            PACLPolicyManager.register(classLoader, paclPolicy);
        }

        public void unregister(ClassLoader classLoader) {
            PACLPolicyManager.unregister(classLoader);
        }
    }

    private static class DoDoPrivilegedPACL
    implements DoPrivilegedUtil.PACL {
        private DoDoPrivilegedPACL() {
        }

        public <T> T wrap(PrivilegedAction<T> privilegedAction) {
            return (T)DoPrivilegedFactory.wrap(AccessController.doPrivileged(privilegedAction));
        }

        public <T> T wrap(PrivilegedExceptionAction<T> privilegedExceptionAction) throws Exception {
            return (T)DoPrivilegedFactory.wrap(AccessController.doPrivileged(privilegedExceptionAction));
        }

        public <T> T wrap(T t) {
            return (T)DoPrivilegedFactory.wrap(t);
        }

        public <T> T wrapWhenActive(T t) {
            return (T)DoPrivilegedFactory.wrap(t);
        }
    }

    private static class DoDirectRequestDispatcherFactoryImplPACL
    implements DirectRequestDispatcherFactoryImpl.PACL {
        private DoDirectRequestDispatcherFactoryImplPACL() {
        }

        public RequestDispatcher getRequestDispatcher(ServletContext servletContext, RequestDispatcher requestDispatcher) {
            return new PACLRequestDispatcherWrapper(servletContext, requestDispatcher);
        }
    }

    private static class DoDataSourceFactoryImplPACL
    implements DataSourceFactoryImpl.PACL {
        private DoDataSourceFactoryImplPACL() {
        }

        public DataSource getDataSource(DataSource dataSource) {
            return new PACLDataSource(dataSource);
        }
    }

    private static class DoDataAccessPACL
    implements DataAccess.PACL {
        private DoDataAccessPACL() {
        }

        public DataSource getDataSource() {
            return AccessController.doPrivileged(new PrivilegedAction<DataSource>(){

                @Override
                public DataSource run() {
                    return InfrastructureUtil.getDataSource();
                }
            });
        }

        public DataSource getDataSource(final String location) throws NamingException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<DataSource>(){

                    @Override
                    public DataSource run() throws Exception {
                        Properties properties = PropsUtil.getProperties((String)"jndi.environment.", (boolean)true);
                        InitialContext context = new InitialContext(properties);
                        return (DataSource)JNDIUtil.lookup((Context)context, (String)location);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NamingException)pae.getException();
            }
        }
    }

    private static class DoClassLoaderUtilPACL
    implements ClassLoaderUtil.PACL {
        private final ClassLoaderUtil.PACL _noPacl = new ClassLoaderUtil.NoPACL();

        private DoClassLoaderUtilPACL() {
        }

        public ClassLoader getAggregatePluginsClassLoader(final String[] servletContextNames, final boolean addContextClassLoader) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return DoClassLoaderUtilPACL.this._noPacl.getAggregatePluginsClassLoader(servletContextNames, addContextClassLoader);
                }
            });
        }

        public ClassLoader getClassLoader(final Class<?> clazz) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return DoClassLoaderUtilPACL.this._noPacl.getClassLoader(clazz);
                }
            });
        }

        public ClassLoader getContextClassLoader() {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return DoClassLoaderUtilPACL.this._noPacl.getContextClassLoader();
                }
            });
        }

        public ClassLoader getPluginClassLoader(final String servletContextName) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return DoClassLoaderUtilPACL.this._noPacl.getPluginClassLoader(servletContextName);
                }
            });
        }

        public ClassLoader getPortalClassLoader() {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return DoClassLoaderUtilPACL.this._noPacl.getPortalClassLoader();
                }
            });
        }

        public void setContextClassLoader(final ClassLoader classLoader) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    DoClassLoaderUtilPACL.this._noPacl.setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    private static class DoBeanReferenceRefreshUtilPACL
    implements BeanReferenceRefreshUtil.PACL {
        private static final Map<Object, Object> _doPrivilegedBeans = new IdentityHashMap<Object, Object>();

        private DoBeanReferenceRefreshUtilPACL() {
        }

        public Object getNewReferencedBean(String referencedBeanName, BeanFactory beanFactory) {
            Object newReferencedBean = null;
            try {
                newReferencedBean = beanFactory.getBean(referencedBeanName);
            }
            catch (NoSuchBeanDefinitionException nsbde) {
                newReferencedBean = PortalBeanLocatorUtil.locate((String)referencedBeanName);
            }
            Object doPrivilegedBean = _doPrivilegedBeans.get(newReferencedBean);
            if (doPrivilegedBean == null && DoPrivilegedFactory.isEarlyBeanReference((String)referencedBeanName)) {
                doPrivilegedBean = DoPrivilegedFactory.wrap((Object)newReferencedBean);
                _doPrivilegedBeans.put(newReferencedBean, doPrivilegedBean);
            }
            if (doPrivilegedBean != null) {
                newReferencedBean = doPrivilegedBean;
            }
            return newReferencedBean;
        }
    }

    private static class DoBeanLocatorImplPACL
    implements BeanLocatorImpl.PACL {
        private DoBeanLocatorImplPACL() {
        }

        public Object getBean(final Object bean, ClassLoader classLoader) {
            String callerClassName;
            Class<?> callerClass;
            ClassLoader callerClassLoader;
            Class<?> beanClass = bean.getClass();
            if (ProxyUtil.isProxyClass(beanClass) && ProxyUtil.getInvocationHandler((Object)bean) instanceof PACLInvocationHandler) {
                return bean;
            }
            Class[] interfaces = ReflectionUtil.getInterfaces((Object)bean, (ClassLoader)classLoader);
            if (interfaces.length == 0) {
                return bean;
            }
            if (classLoader == ClassLoaderUtil.getPortalClassLoader() && (callerClassLoader = ClassLoaderUtil.getClassLoader(callerClass = Reflection.getCallerClass(5))) == classLoader && !(callerClassName = callerClass.getName()).equals(BeanReferenceAnnotationBeanPostProcessor.class.getName())) {
                return bean;
            }
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                    return method.invoke(bean, arguments);
                }
            };
            invocationHandler = new PACLInvocationHandler(invocationHandler);
            return ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])interfaces, (InvocationHandler)invocationHandler);
        }
    }
}

