/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.security.pacl.permission.PortalHookPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalMessageBusPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.security.pacl.LenientPermissionCollection;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.security.pacl.PACLUtil;
import com.liferay.portal.security.pacl.PortalPermissionCollection;
import com.liferay.portal.security.pacl.URLWrapper;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;

public class PortalPolicy
extends Policy {
    private static final ThreadLocal<Boolean> _started = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Field _field;
    private final PACLPolicy _paclPolicy = PACLPolicyManager.getDefaultPACLPolicy();
    private final ConcurrentMap<Object, PermissionCollection> _permissionCollections = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private final Policy _policy;
    private final ConcurrentMap<URLWrapper, PermissionCollection> _urlPermissionCollections = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public PortalPolicy(Policy policy) throws PrivilegedActionException {
        if (policy instanceof PortalPolicy) {
            throw new IllegalArgumentException("Liferay's PortalPolicy class should not wrap itself");
        }
        this._policy = policy;
        this._field = AccessController.doPrivileged(new FieldPrivilegedExceptionAction());
    }

    public Policy getOriginalPolicy() {
        return this._policy;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (codeSource == null || codeSource.getLocation() == null) {
            return new LenientPermissionCollection();
        }
        URLWrapper urlWrapper = new URLWrapper(codeSource.getLocation());
        PermissionCollection permissionCollection = (PermissionCollection)this._urlPermissionCollections.get(urlWrapper);
        if (permissionCollection != null) {
            return permissionCollection;
        }
        PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(codeSource.getLocation());
        permissionCollection = paclPolicy != null ? new PortalPermissionCollection(paclPolicy) : new LenientPermissionCollection();
        this._urlPermissionCollections.put(urlWrapper, permissionCollection);
        return permissionCollection;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        CodeSource codeSource;
        if (protectionDomain == null) {
            return new LenientPermissionCollection();
        }
        Object key = this._getKey(protectionDomain);
        PermissionCollection permissionCollection = null;
        if (key != null) {
            permissionCollection = (PermissionCollection)this._permissionCollections.get(key);
        }
        if (permissionCollection == null && (codeSource = protectionDomain.getCodeSource()) != null && codeSource.getLocation() != null) {
            permissionCollection = (PermissionCollection)this._urlPermissionCollections.get(new URLWrapper(codeSource.getLocation()));
        }
        if (permissionCollection != null) {
            return permissionCollection;
        }
        PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(protectionDomain);
        permissionCollection = paclPolicy != null ? new PortalPermissionCollection(paclPolicy) : (JavaDetector.isIBM() ? this._policy.getPermissions(protectionDomain) : new LenientPermissionCollection());
        if (key != null) {
            this._permissionCollections.put(key, permissionCollection);
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        if (_started.get().booleanValue()) {
            return true;
        }
        try {
            _started.set(true);
            PermissionCollection permissionCollection = null;
            if (JavaDetector.isIBM() && (permissionCollection = this.getPermissions(protectionDomain)) != null && !(permissionCollection instanceof PortalPermissionCollection)) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    Permission curPermission = enumeration.nextElement();
                    if (!(curPermission instanceof AllPermission)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            if (!(permission instanceof PACLUtil.Permission) && !this._paclPolicy.isCheckablePermission(permission)) {
                boolean bl = this._checkWithParentPolicy(protectionDomain, permission);
                return bl;
            }
            if (!JavaDetector.isIBM()) {
                permissionCollection = this.getPermissions(protectionDomain);
            }
            if (permissionCollection instanceof PortalPermissionCollection) {
                if (permissionCollection.implies(permission) || this._checkWithPACLPolicyPolicy(protectionDomain, permission, permissionCollection)) {
                    boolean bl = true;
                    return bl;
                }
                throw new AccessControlException("Access denied " + permission, permission);
            }
            boolean bl = this._checkWithParentPolicy(protectionDomain, permission);
            return bl;
        }
        finally {
            _started.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this._policy != null) {
            this._policy.refresh();
        }
        ConcurrentMap<Object, PermissionCollection> concurrentMap = this._permissionCollections;
        synchronized (concurrentMap) {
            this._permissionCollections.clear();
            this._urlPermissionCollections.clear();
        }
    }

    private boolean _checkWithPACLPolicyPolicy(ProtectionDomain protectionDomain, Permission permission, PermissionCollection permissionCollection) {
        PortalPermissionCollection portalPermissionCollection = (PortalPermissionCollection)permissionCollection;
        Policy policy = portalPermissionCollection.getPolicy();
        ClassLoader classLoader = portalPermissionCollection.getClassLoader();
        if (policy != null && classLoader == protectionDomain.getClassLoader()) {
            return policy.implies(protectionDomain, permission);
        }
        return false;
    }

    private boolean _checkWithParentPolicy(ProtectionDomain protectionDomain, Permission permission) {
        if (!(this._policy == null || permission instanceof PortalHookPermission || permission instanceof PortalMessageBusPermission || permission instanceof PortalRuntimePermission || permission instanceof PortalServicePermission || permission instanceof PACLUtil.Permission)) {
            return this._policy.implies(protectionDomain, permission);
        }
        return true;
    }

    private Object _getKey(ProtectionDomain protectionDomain) {
        try {
            return this._field.get(protectionDomain);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class FieldPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Field> {
        private FieldPrivilegedExceptionAction() {
        }

        @Override
        public Field run() throws Exception {
            Field field = ProtectionDomain.class.getDeclaredField("key");
            field.setAccessible(true);
            return field;
        }
    }
}

