/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.security.pacl.PACLPolicyThreadLocal;
import com.liferay.portal.security.pacl.PortalPermissionCollection;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class PACLUtil {
    private static final Permission _permission = new Permission();

    public static Class<?> getClass(Object object) {
        Class<?>[] interfaces;
        Class<?> clazz = object.getClass();
        if (object instanceof Class) {
            clazz = (Class<?>)object;
        }
        if ((ProxyUtil.isProxyClass(clazz) || !clazz.isInterface()) && (interfaces = clazz.getInterfaces()).length > 0 && (clazz = interfaces[0]).equals(CacheRegistryItem.class) && interfaces.length > 1) {
            clazz = interfaces[1];
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PACLPolicy getPACLPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            PACLPolicy paclPolicy;
            securityManager.checkPermission(_permission);
            PACLPolicy pACLPolicy = paclPolicy = PACLPolicyThreadLocal.get();
            return pACLPolicy;
        }
        finally {
            PACLPolicyThreadLocal.set(null);
        }
    }

    public static String getServiceInterfaceName(String serviceClassName) {
        int pos = serviceClassName.indexOf(".impl.");
        if (pos != -1) {
            serviceClassName = serviceClassName.substring(0, pos + 1) + serviceClassName.substring(pos + 6);
        }
        if (serviceClassName.endsWith("Impl")) {
            serviceClassName = serviceClassName.substring(0, serviceClassName.length() - 4);
        }
        return serviceClassName;
    }

    public static boolean hasSameOrigin(Class<?> callerClass) {
        PACLPolicy paclPolicy = PACLUtil.getPACLPolicy();
        if (paclPolicy == null) {
            return true;
        }
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new ProtectionDomainPrivilegedAction(callerClass));
        PortalSecurityManager portalSecurityManager = SecurityManagerUtil.getPortalSecurityManager();
        Policy portalPolicy = portalSecurityManager.getPolicy();
        PermissionCollection permissionCollection = portalPolicy.getPermissions(protectionDomain);
        return PACLUtil._hasSameOrigin(protectionDomain, permissionCollection, paclPolicy);
    }

    public static boolean isTrustedCaller(Class<?> callerClass, java.security.Permission permission, PACLPolicy paclPolicy) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new ProtectionDomainPrivilegedAction(callerClass));
        return PACLUtil._isTrustedCaller(protectionDomain, permission, paclPolicy);
    }

    private static boolean _hasSameOrigin(ProtectionDomain protectionDomain, PermissionCollection permissionCollection, PACLPolicy paclPolicy) {
        PACLPolicy callerPACLPolicy = null;
        if (permissionCollection instanceof PortalPermissionCollection) {
            PortalPermissionCollection portalPermissionCollection = (PortalPermissionCollection)permissionCollection;
            callerPACLPolicy = portalPermissionCollection.getPACLPolicy();
        } else {
            callerPACLPolicy = PACLPolicyManager.getPACLPolicy(protectionDomain);
        }
        return paclPolicy == callerPACLPolicy;
    }

    private static boolean _isTrustedCaller(ProtectionDomain protectionDomain, java.security.Permission permission, PACLPolicy paclPolicy) {
        PortalSecurityManager portalSecurityManager = SecurityManagerUtil.getPortalSecurityManager();
        Policy portalPolicy = portalSecurityManager.getPolicy();
        PermissionCollection permissionCollection = portalPolicy.getPermissions(protectionDomain);
        return !PACLUtil._hasSameOrigin(protectionDomain, permissionCollection, paclPolicy) && permissionCollection.implies(permission);
    }

    private static class ProtectionDomainPrivilegedAction
    implements PrivilegedAction<ProtectionDomain> {
        private final Class<?> _clazz;

        public ProtectionDomainPrivilegedAction(Class<?> clazz) {
            this._clazz = clazz;
        }

        @Override
        public ProtectionDomain run() {
            return this._clazz.getProtectionDomain();
        }
    }

    public static class Permission
    extends BasicPermission {
        public Permission() {
            super("getPACLPolicy");
        }
    }
}

