/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.url.URLContainer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.security.pacl.ActivePACLPolicy;
import com.liferay.portal.security.pacl.GeneratingPACLPolicy;
import com.liferay.portal.security.pacl.InactivePACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.URLWrapper;
import com.liferay.portal.util.PropsValues;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PACLPolicyManager {
    private static final Map<ClassLoader, PACLPolicy> _classLoaderPACLPolicies = new ConcurrentHashMap<ClassLoader, PACLPolicy>();
    private static final PACLPolicy _defaultPACLPolicy = new InactivePACLPolicy("", new InactiveURLContainer(), PACLPolicyManager.class.getClassLoader(), new Properties());
    private static final Map<URLWrapper, PACLPolicy> _urlPACLPolicies = new ConcurrentHashMap<URLWrapper, PACLPolicy>();

    public static PACLPolicy buildPACLPolicy(String contextName, URLContainer urlContainer, ClassLoader classLoader, Properties properties) {
        String value = properties.getProperty("security-manager-enabled", "false");
        if (value.equals("generate")) {
            return new GeneratingPACLPolicy(contextName, urlContainer, classLoader, properties);
        }
        if (GetterUtil.getBoolean((String)value)) {
            return new ActivePACLPolicy(contextName, urlContainer, classLoader, properties);
        }
        return new InactivePACLPolicy(contextName, urlContainer, classLoader, properties);
    }

    public static PACLPolicy getDefaultPACLPolicy() {
        return _defaultPACLPolicy;
    }

    public static PACLPolicy getPACLPolicy(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(classLoader));
    }

    public static PACLPolicy getPACLPolicy(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(protectionDomain));
    }

    public static PACLPolicy getPACLPolicy(URL locationURL) {
        if (locationURL == null) {
            return null;
        }
        return AccessController.doPrivileged(new PACLPolicyPrivilegedAction(locationURL));
    }

    public static void register(ClassLoader classLoader, PACLPolicy paclPolicy) {
        URLContainer urlContainer;
        URL rootURL;
        String path;
        List<URL> urLs = paclPolicy.getURLs();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                String path2 = url.getPath();
                if (path2.startsWith(PropsValues.LIFERAY_LIB_GLOBAL_SHARED_DIR)) continue;
                urLs.add(url);
                _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
            }
        }
        if ((path = (rootURL = (urlContainer = paclPolicy.getURLContainer()).getResource("/")).getPath()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            URL url = new URL("file", "", -1, path);
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
            url = new URL("file", "", -1, path + "/");
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
            url = new URL("file", "", -1, path + "/WEB-INF/classes/*");
            urLs.add(url);
            _urlPACLPolicies.put(new URLWrapper(url), paclPolicy);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException(murle);
        }
        _classLoaderPACLPolicies.put(classLoader, paclPolicy);
        PACLPolicyManager._refresh();
    }

    public static void unregister(ClassLoader classLoader) {
        PACLPolicy paclPolicy = _classLoaderPACLPolicies.remove(classLoader);
        for (URL url : paclPolicy.getURLs()) {
            _urlPACLPolicies.remove(url);
        }
        PACLPolicyManager._refresh();
    }

    private static void _refresh() {
        PortalSecurityManager portalSecurityManager = SecurityManagerUtil.getPortalSecurityManager();
        Policy policy = portalSecurityManager.getPolicy();
        policy.refresh();
    }

    private static class PACLPolicyPrivilegedAction
    implements PrivilegedAction<PACLPolicy> {
        private ClassLoader _classLoader;
        private URL _locationURL;

        public PACLPolicyPrivilegedAction(ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        public PACLPolicyPrivilegedAction(ProtectionDomain protectionDomain) {
            this._classLoader = protectionDomain.getClassLoader();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return;
            }
            this._locationURL = codeSource.getLocation();
        }

        public PACLPolicyPrivilegedAction(URL locationURL) {
            this._locationURL = locationURL;
        }

        @Override
        public PACLPolicy run() {
            PACLPolicy paclPolicy = this._getFromClassLoader();
            if (paclPolicy != null || this._classLoader != null || this._locationURL == null) {
                return paclPolicy;
            }
            return (PACLPolicy)_urlPACLPolicies.get(new URLWrapper(this._locationURL));
        }

        private PACLPolicy _getFromClassLoader() {
            if (this._classLoader == null) {
                return null;
            }
            PACLPolicy paclPolicy = (PACLPolicy)_classLoaderPACLPolicies.get(this._classLoader);
            while (paclPolicy == null && this._classLoader.getParent() != null) {
                this._classLoader = this._classLoader.getParent();
                paclPolicy = (PACLPolicy)_classLoaderPACLPolicies.get(this._classLoader);
            }
            return paclPolicy;
        }
    }

    private static class InactiveURLContainer
    implements URLContainer {
        private InactiveURLContainer() {
        }

        public URL getResource(String name) {
            return null;
        }

        public Set<String> getResources(String path) {
            return Collections.emptySet();
        }
    }
}

