/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.spring.aop.AdvisedSupportProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.springframework.aop.framework.AdvisedSupport;

public class PACLInvocationHandler
implements AdvisedSupportProxy,
InvocationHandler {
    private final AdvisedSupport _advisedSupport;
    private InvocationHandler _invocationHandler;

    public PACLInvocationHandler(InvocationHandler invocationHandler) {
        this(invocationHandler, null);
    }

    public PACLInvocationHandler(InvocationHandler invocationHandler, AdvisedSupport advisedSupport) {
        this._invocationHandler = invocationHandler;
        this._advisedSupport = advisedSupport;
    }

    public AdvisedSupport getAdvisedSupport() {
        return this._advisedSupport;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            return this.doInvoke(proxy, method, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Object doInvoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (proxy == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("toString")) {
                return this._invocationHandler.invoke(proxy, method, arguments);
            }
        }
        PortalServicePermission.checkService((Object)proxy, (Method)method, (Object[])arguments);
        try {
            return AccessController.doPrivileged(new InvokePrivilegedExceptionAction(this._invocationHandler, proxy, method, arguments));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException().getCause();
        }
    }

    private static class InvokePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Object> {
        private final Object[] _arguments;
        private InvocationHandler _invocationHandler;
        private final Method _method;
        private final Object _proxy;

        public InvokePrivilegedExceptionAction(InvocationHandler invocationHandler, Object proxy, Method method, Object[] arguments) {
            this._invocationHandler = invocationHandler;
            this._proxy = proxy;
            this._method = method;
            this._arguments = arguments;
        }

        @Override
        public Object run() throws Exception {
            try {
                return this._invocationHandler.invoke(this._proxy, this._method, this._arguments);
            }
            catch (Throwable t) {
                throw new Exception(t);
            }
        }
    }
}

