/*
 * Decompiled with CFR 0.152.
 */
package org.monte.movieconverter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import org.monte.media.Buffer;
import org.monte.media.Movie;
import org.monte.media.gui.ImagePanel;
import org.monte.media.gui.JMovieControlPanel;
import org.monte.media.gui.Worker;
import org.monte.media.math.Rational;

public class MovieConverterPanel
extends JPanel {
    private ExecutorService executor;
    private Buffer imageBuffer = new Buffer();
    private Handler handler = new Handler();
    private long imageTime = -1L;
    private ImagePanel imagePanel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JMovieControlPanel movieControlPanel;
    private JToolBar toolBar;

    public MovieConverterPanel() {
        this.initComponents();
    }

    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        this.movieControlPanel.setTransferHandler(newHandler);
        this.jPanel1.setTransferHandler(newHandler);
        this.toolBar.setTransferHandler(newHandler);
        this.toolBar.putClientProperty("Quaqua.ToolBar.style", "bottom");
    }

    private void updateImage() {
        final Movie movie = this.getMovie();
        if (movie == null) {
            return;
        }
        this.execute(new Worker<BufferedImage>(){

            @Override
            protected BufferedImage construct() throws Exception {
                Rational time = movie.getInsertionPoint();
                return null;
            }

            @Override
            protected void done(BufferedImage value) {
                MovieConverterPanel.this.imagePanel.setImage(value);
            }
        });
    }

    public void execute(Runnable worker) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.executor.execute(worker);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.movieControlPanel = new JMovieControlPanel();
        this.imagePanel = new ImagePanel();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.jLabel1.setText(" ");
        this.toolBar.add(this.jLabel1);
        this.add((Component)this.toolBar, "Last");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.movieControlPanel, "South");
        this.jPanel1.add((Component)this.imagePanel, "Center");
        this.add((Component)this.jPanel1, "Center");
    }

    public void setMovie(Movie movie) {
        Movie oldValue = this.movieControlPanel.getMovie();
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.handler);
        }
        this.movieControlPanel.setMovie(movie);
        if (movie != null) {
            movie.addPropertyChangeListener(this.handler);
        }
        this.imageTime = -1L;
        this.updateImage();
    }

    private Movie getMovie() {
        return this.movieControlPanel.getMovie();
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "playhead") {
                MovieConverterPanel.this.updateImage();
            }
        }
    }
}

