/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.DataAtomInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickTimeInputStream
extends AbstractQuickTimeStream {
    protected final ImageInputStream in;
    private boolean isRealized = false;
    static final HashSet<String> compositeAtoms = new HashSet();

    public QuickTimeInputStream(File file) throws IOException {
        this.in = new FileImageInputStream(file);
        this.in.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.streamOffset = 0L;
    }

    public QuickTimeInputStream(ImageInputStream in) throws IOException {
        this.in = in;
        this.streamOffset = in.getStreamPosition();
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public int getTrackCount() throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getMovieDuration() throws IOException {
        this.ensureRealized();
        long duration = 0L;
        for (AbstractQuickTimeStream.Track t : this.tracks) {
            duration = Math.max(duration, t.getTrackDuration(this.movieTimeScale));
        }
        return duration;
    }

    public Date getCreationTime() throws IOException {
        this.ensureRealized();
        return this.creationTime;
    }

    public Date getModificationTime() throws IOException {
        this.ensureRealized();
        return this.modificationTime;
    }

    public double getPreferredRate() throws IOException {
        this.ensureRealized();
        return this.preferredRate;
    }

    public double getPreferredVolume() throws IOException {
        this.ensureRealized();
        return this.preferredVolume;
    }

    public long getCurrentTime() throws IOException {
        this.ensureRealized();
        return this.currentTime;
    }

    public long getPosterTime() throws IOException {
        this.ensureRealized();
        return this.posterTime;
    }

    public long getPreviewDuration() throws IOException {
        this.ensureRealized();
        return this.previewDuration;
    }

    public long getPreviewTime() throws IOException {
        this.ensureRealized();
        return this.previewTime;
    }

    public double[] getMovieTransformationMatrix() throws IOException {
        this.ensureRealized();
        return (double[])this.movieMatrix.clone();
    }

    public long getMovieTimeScale() throws IOException {
        this.ensureRealized();
        return this.movieTimeScale;
    }

    public long getMediaTimeScale(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaTimeScale;
    }

    public long getMediaDuration(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).mediaDuration;
    }

    public double[] getTransformationMatrix(int track) throws IOException {
        this.ensureRealized();
        return (double[])((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).matrix.clone();
    }

    protected void ensureRealized() throws IOException {
        if (!this.isRealized) {
            this.isRealized = true;
            this.readAllMetadata();
        }
    }

    private void readAllMetadata() throws IOException {
        long remainingSize = this.in.length();
        if (remainingSize == -1L) {
            remainingSize = Long.MAX_VALUE;
        }
        this.in.seek(0L);
        this.readAllMetadata(new DataAtomInputStream(new ImageInputStreamAdapter(this.in)), remainingSize, new HashMap<String, InputAtom>(), null);
    }

    private void readAllMetadata(DataAtomInputStream in, long remainingSize, HashMap<String, InputAtom> atoms, String path) throws IOException {
        long pos = 0L;
        while (remainingSize > 0L) {
            long size = (long)in.readInt() & 0xFFFFFFFFL;
            int headerSize = 8;
            if (size == 0L) {
                size = remainingSize;
                if ((long)(headerSize + 4) <= remainingSize) {
                    in.skipBytes(4L);
                    headerSize += 4;
                }
            } else if (size == 1L) {
                headerSize = 16;
                size = in.readLong();
            }
            long atomSize = size;
            if (size > remainingSize) {
                size = remainingSize;
            }
            String type = size - (long)headerSize >= 0L ? QuickTimeInputStream.intToType(in.readInt()) : "";
            remainingSize -= size;
            if (type.equals("stsd")) {
                // empty if block
            }
            if (compositeAtoms.contains(type) && size - (long)headerSize >= 8L) {
                if (type.equals("trak")) {
                    atoms.clear();
                    this.readAllMetadata(in, size - (long)headerSize, atoms, path == null ? type : path + "." + type);
                    this.parseTrack(atoms);
                } else {
                    this.readAllMetadata(in, size - (long)headerSize, atoms, path == null ? type : path + "." + type);
                }
            } else {
                byte[] data;
                if (type.equals("mdat")) {
                    long skipValue;
                    data = new byte[]{};
                    for (long skipped = 0L; skipped < size - (long)headerSize; skipped += skipValue) {
                        skipValue = in.skipBytes(size - (long)headerSize - skipped);
                        if (skipValue > 0L) {
                            continue;
                        }
                        throw new IOException("unable to skip");
                    }
                } else if (size < (long)headerSize) {
                    data = new byte[]{};
                } else {
                    data = new byte[(int)(size - (long)headerSize)];
                    in.readFully(data);
                }
                InputAtom atom = new InputAtom(type, data);
                atoms.put(path == null ? type : path + "." + type, atom);
                if (type.equals("cmvd")) {
                    try {
                        int b;
                        InflaterInputStream in2 = new InflaterInputStream(new ByteArrayInputStream(data, 4, data.length - 4));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        while ((b = ((InputStream)in2).read()) != -1) {
                            out.write(b);
                        }
                        ((InputStream)in2).close();
                        out.close();
                        byte[] decompressed = out.toByteArray();
                        this.readAllMetadata(new DataAtomInputStream(new ByteArrayInputStream(decompressed)), decompressed.length, atoms, path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (type.equals("mvhd")) {
                    this.parseMovieHeader(data);
                }
            }
            pos += size;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    private void parseMovieHeader(byte[] data) throws IOException {
        DataAtomInputStream i = new DataAtomInputStream(new ByteArrayInputStream(data));
        byte version = i.readByte();
        i.skipBytes(3L);
        this.creationTime = i.readMacTimestamp();
        this.modificationTime = i.readMacTimestamp();
        this.movieTimeScale = i.readUInt();
        long movieDuration = i.readUInt();
        this.preferredRate = i.readFixed16D16();
        this.preferredVolume = i.readFixed8D8();
        i.skipBytes(10L);
        this.movieMatrix[0] = i.readFixed16D16();
        this.movieMatrix[1] = i.readFixed16D16();
        this.movieMatrix[2] = i.readFixed2D30();
        this.movieMatrix[3] = i.readFixed16D16();
        this.movieMatrix[4] = i.readFixed16D16();
        this.movieMatrix[5] = i.readFixed2D30();
        this.movieMatrix[6] = i.readFixed16D16();
        this.movieMatrix[7] = i.readFixed16D16();
        this.movieMatrix[8] = i.readFixed2D30();
        this.previewTime = i.readUInt();
        this.previewDuration = i.readUInt();
        this.posterTime = i.readUInt();
        this.selectionTime = i.readUInt();
        this.selectionDuration = i.readUInt();
        this.currentTime = i.readUInt();
        long nextTrackId = i.readUInt();
    }

    private void parseTrack(HashMap<String, InputAtom> atoms) throws IOException {
        AbstractQuickTimeStream.Track t;
        for (String p : atoms.keySet()) {
            System.out.println("QuickTimeInputStream " + p);
        }
        HashMap<String, Object> hdlrMap = this.parseHdlr(atoms.get("moov.trak.mdia.hdlr").data);
        String trackType = (String)hdlrMap.get("componentSubtype");
        if ("vide".equals(trackType)) {
            t = new AbstractQuickTimeStream.VideoTrack();
        } else if ("soun".equals(trackType)) {
            t = new AbstractQuickTimeStream.AudioTrack();
        } else {
            throw new IOException("Unsupported track type: " + trackType);
        }
        this.parseTkhd(t, atoms.get("moov.trak.tkhd").data);
        if (atoms.get("moov.trak.edts") != null) {
            this.parseEdts(t, atoms.get("moov.trak.edts").data);
        }
        if (atoms.get("moov.trak.mdhd") != null) {
            this.parseMdhd(t, atoms.get("moov.trak.mdhd").data);
        }
        if ("vide".equals(trackType)) {
            this.parseVideoTrack((AbstractQuickTimeStream.VideoTrack)t, atoms);
        } else if ("soun".equals(trackType)) {
            this.parseAudioTrack((AbstractQuickTimeStream.AudioTrack)t, atoms);
        } else {
            throw new IOException("Unsupported track type: " + trackType);
        }
        this.tracks.add(t);
    }

    private void parseVideoTrack(AbstractQuickTimeStream.VideoTrack t, HashMap<String, InputAtom> atoms) throws IOException {
    }

    private void parseAudioTrack(AbstractQuickTimeStream.AudioTrack t, HashMap<String, InputAtom> atoms) throws IOException {
    }

    private void parseTkhd(AbstractQuickTimeStream.Track t, byte[] data) throws IOException {
        DataAtomInputStream dain = new DataAtomInputStream(new ByteArrayInputStream(data));
        byte version = dain.readByte();
        dain.skipBytes(2L);
        int trackHeaderFlags = dain.readUByte();
        Date creationTime = dain.readMacTimestamp();
        Date modificationTime = dain.readMacTimestamp();
        int trackId = dain.readInt();
        dain.skipBytes(4L);
        long duration = dain.readUInt();
        dain.skipBytes(8L);
        int layer = dain.readUShort();
        int alternateGroup = dain.readUShort();
        double volume = dain.readFixed8D8();
        dain.skipBytes(2L);
        t.matrix[0] = dain.readFixed16D16();
        t.matrix[1] = dain.readFixed16D16();
        t.matrix[2] = dain.readFixed2D30();
        t.matrix[3] = dain.readFixed16D16();
        t.matrix[4] = dain.readFixed16D16();
        t.matrix[5] = dain.readFixed2D30();
        t.matrix[6] = dain.readFixed16D16();
        t.matrix[7] = dain.readFixed16D16();
        t.matrix[8] = dain.readFixed2D30();
        t.width = dain.readFixed16D16();
        t.height = dain.readFixed16D16();
    }

    private HashMap<String, Object> parseHdlr(byte[] data) throws IOException {
        DataAtomInputStream i = new DataAtomInputStream(new ByteArrayInputStream(data));
        byte version = i.readByte();
        int flags = i.readUShort() << 8 | i.readUByte();
        String componentType = i.readType();
        String componentSubtype = i.readType();
        String componentManufactureer = i.readType();
        int componentFlags = i.readInt();
        int componentFlagsMask = i.readInt();
        String componentName = i.readPString();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("componentSubtype", componentSubtype);
        return m;
    }

    private void parseEdts(AbstractQuickTimeStream.Track t, byte[] data) throws IOException {
        DataAtomInputStream dain = new DataAtomInputStream(new ByteArrayInputStream(data));
        byte version = dain.readByte();
        int flags = dain.readUShort() << 8 | dain.readUByte();
        int numberOfEntries = dain.readInt();
        t.editList = new AbstractQuickTimeStream.Edit[numberOfEntries];
        for (int i = 0; i < numberOfEntries; ++i) {
            AbstractQuickTimeStream.Edit edit;
            t.editList[i] = edit = new AbstractQuickTimeStream.Edit(dain.readInt(), dain.readInt(), dain.readFixed16D16());
        }
    }

    private void parseMdhd(AbstractQuickTimeStream.Track t, byte[] data) throws IOException {
        DataAtomInputStream dain = new DataAtomInputStream(new ByteArrayInputStream(data));
        byte version = dain.readByte();
        int flags = dain.readUShort() << 8 | dain.readUByte();
        Date creationTime = dain.readMacTimestamp();
        Date modificationTime = dain.readMacTimestamp();
        t.mediaTimeScale = dain.readUInt();
        t.mediaDuration = dain.readUInt();
        short language = dain.readShort();
        short quality = dain.readShort();
    }

    static {
        compositeAtoms.add("moov");
        compositeAtoms.add("cmov");
        compositeAtoms.add("gmhd");
        compositeAtoms.add("trak");
        compositeAtoms.add("tref");
        compositeAtoms.add("meta");
        compositeAtoms.add("ilst");
        compositeAtoms.add("mdia");
        compositeAtoms.add("minf");
        compositeAtoms.add("udta");
        compositeAtoms.add("stbl");
        compositeAtoms.add("dinf");
        compositeAtoms.add("edts");
        compositeAtoms.add("clip");
        compositeAtoms.add("matt");
        compositeAtoms.add("rmra");
        compositeAtoms.add("rmda");
        compositeAtoms.add("tapt");
        compositeAtoms.add("mvex");
    }

    private class InputAtom
    extends AbstractQuickTimeStream.Atom {
        private byte[] data;

        public InputAtom(String type, byte[] data) throws IOException {
            super(type, -1L);
            this.data = data;
        }

        public void finish() throws IOException {
        }

        public long size() {
            return this.data.length;
        }
    }
}

