/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.monte.media.FormatKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Format {
    private HashMap<FormatKey, Object> properties;

    public Format(Map<FormatKey, Object> properties) {
        this(properties, true);
    }

    private Format(Map<FormatKey, Object> properties, boolean copy) {
        if (copy || !(properties instanceof HashMap)) {
            for (Map.Entry<FormatKey, Object> e : properties.entrySet()) {
                if (e.getKey().isAssignable(e.getValue())) continue;
                throw new ClassCastException(e.getValue() + " must be of type " + e.getKey().getValueClass());
            }
            this.properties = new HashMap<FormatKey, Object>(properties);
        } else {
            this.properties = (HashMap)properties;
        }
    }

    public Format(Object ... p) {
        this.properties = new HashMap();
        for (int i = 0; i < p.length; i += 2) {
            FormatKey key = (FormatKey)p[i];
            if (!key.isAssignable(p[i + 1])) {
                throw new ClassCastException(key + ": " + p[i + 1] + " must be of type " + key.getValueClass());
            }
            this.properties.put(key, p[i + 1]);
        }
    }

    public <T> T get(FormatKey<T> key) {
        return (T)this.properties.get(key);
    }

    public <T> T get(FormatKey<T> key, T defaultValue) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : defaultValue);
    }

    public boolean containsKey(FormatKey key) {
        return this.properties.containsKey(key);
    }

    public Map<FormatKey, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<FormatKey> getKeys() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public boolean matches(Format that) {
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            Object b;
            Object a;
            if (e.getKey().isComment() || !that.properties.containsKey(e.getKey()) || ((a = e.getValue()) == (b = that.properties.get(e.getKey())) || a != null) && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesWithout(Format that, FormatKey ... without) {
        block0: for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            Object b;
            FormatKey k = e.getKey();
            if (e.getKey().isComment() || !that.properties.containsKey(k)) continue;
            for (int i = 0; i < without.length; ++i) {
                if (without[i] == k) continue block0;
            }
            Object a = e.getValue();
            if ((a == (b = that.properties.get(k)) || a != null) && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public Format append(Format that) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (Map.Entry<FormatKey, Object> e : that.properties.entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        return new Format(m, false);
    }

    public Format append(Object ... p) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (int i = 0; i < p.length; i += 2) {
            FormatKey key = (FormatKey)p[i];
            if (!key.isAssignable(p[i + 1])) {
                throw new ClassCastException(key + ": " + p[i + 1] + " must be of type " + key.getValueClass());
            }
            m.put(key, p[i + 1]);
        }
        return new Format(m, false);
    }

    public Format prepend(Format that) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(that.properties);
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        return new Format(m, false);
    }

    public Format prepend(Object ... p) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>();
        for (int i = 0; i < p.length; i += 2) {
            FormatKey key = (FormatKey)p[i];
            if (!key.isAssignable(p[i + 1])) {
                throw new ClassCastException(key + ": " + p[i + 1] + " must be of type " + key.getValueClass());
            }
            m.put(key, p[i + 1]);
        }
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        return new Format(m, false);
    }

    public Format intersectKeys(FormatKey ... keys) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>();
        for (FormatKey k : keys) {
            if (!this.properties.containsKey(k)) continue;
            m.put(k, this.properties.get(k));
        }
        return new Format(m, false);
    }

    public Format removeKeys(FormatKey ... keys) {
        boolean needsRemoval = false;
        for (FormatKey k : keys) {
            if (!this.properties.containsKey(k)) continue;
            needsRemoval = true;
            break;
        }
        if (!needsRemoval) {
            return this;
        }
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (FormatKey k : keys) {
            m.remove(k);
        }
        return new Format(m, false);
    }

    public Format containsKeys(FormatKey ... keys) {
        HashMap<FormatKey, Object> m = new HashMap<FormatKey, Object>(this.properties);
        for (FormatKey k : keys) {
            m.remove(k);
        }
        return new Format(m, false);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Format{");
        boolean isFirst = true;
        for (Map.Entry<FormatKey, Object> e : this.properties.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            buf.append(e.getKey().toString());
            buf.append(':');
            Format.appendStuffedString(e.getValue(), buf);
        }
        buf.append('}');
        return buf.toString();
    }

    private static void appendStuffedString(Object value, StringBuilder stuffed) {
        if (value == null) {
            stuffed.append("null");
        }
        if ((value = value.toString()) instanceof String) {
            for (char ch : ((String)value).toCharArray()) {
                if (ch >= ' ') {
                    stuffed.append(ch);
                    continue;
                }
                String hex = Integer.toHexString(ch);
                stuffed.append("\\u");
                for (int i = hex.length(); i < 4; ++i) {
                    stuffed.append('0');
                }
                stuffed.append(hex);
            }
        }
    }
}

