/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.monte.media.Animator;
import org.monte.media.Interpolator;

public class DefaultAnimator
implements Animator {
    protected EventListenerList listenerList = new EventListenerList();
    private Vector activeInterpolators;
    private Vector newInterpolators;
    private Thread animationThread;
    private boolean isAnimating;
    private Object lock = new Object();
    protected ChangeEvent changeEvent;
    private int sleep = 33;

    public DefaultAnimator() {
        this.activeInterpolators = new Vector();
        this.newInterpolators = new Vector();
    }

    public void setLock(Object lock) {
        this.lock = lock;
    }

    public boolean isActive() {
        return this.animationThread != null;
    }

    public void start() {
        this.stop();
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public void stop() {
        if (this.animationThread != null) {
            Thread t = this.animationThread;
            this.animationThread = null;
            t.interrupt();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Interpolator interpolator) {
        Vector vector = this.newInterpolators;
        synchronized (vector) {
            this.newInterpolators.addElement(interpolator);
            if (!this.isActive()) {
                this.start();
            }
        }
    }

    public void animateStep() {
        int i;
        long now = System.currentTimeMillis();
        for (i = 0; i < this.newInterpolators.size(); ++i) {
            Interpolator before;
            int j;
            Interpolator candidate = (Interpolator)this.newInterpolators.elementAt(i);
            boolean isEnqueueable = true;
            for (j = 0; j < i; ++j) {
                before = (Interpolator)this.newInterpolators.elementAt(j);
                if (!candidate.isSequential(before)) continue;
                isEnqueueable = false;
                break;
            }
            if (isEnqueueable) {
                for (j = 0; j < this.activeInterpolators.size(); ++j) {
                    before = (Interpolator)this.activeInterpolators.elementAt(j);
                    if (candidate.replaces(before)) {
                        before.finish(now);
                    }
                    if (!candidate.isSequential(before)) continue;
                    isEnqueueable = false;
                    break;
                }
            }
            if (!isEnqueueable) continue;
            candidate.initialize(now);
            this.activeInterpolators.addElement(candidate);
            this.newInterpolators.removeElementAt(i--);
        }
        for (i = 0; i < this.activeInterpolators.size(); ++i) {
            Interpolator active = (Interpolator)this.activeInterpolators.elementAt(i);
            if (active.isFinished()) {
                this.activeInterpolators.removeElementAt(i--);
                continue;
            }
            if (active.isElapsed(now)) {
                active.finish(now);
                this.activeInterpolators.removeElementAt(i--);
                continue;
            }
            active.interpolate(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (Thread.currentThread() == this.animationThread) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.animateStep();
            }
            boolean hasFinished = false;
            object = this.newInterpolators;
            synchronized (object) {
                if (this.activeInterpolators.size() == 0 && this.newInterpolators.size() == 0) {
                    this.animationThread = null;
                    hasFinished = true;
                }
            }
            if (hasFinished) {
                this.fireStateChanged();
                return;
            }
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        Vector vector = this.newInterpolators;
        synchronized (vector) {
            object = this.lock;
            synchronized (object) {
                int i;
                long now = System.currentTimeMillis();
                for (i = 0; i < this.activeInterpolators.size(); ++i) {
                    Interpolator active = (Interpolator)this.activeInterpolators.elementAt(i);
                    active.finish(now);
                }
                for (i = 0; i < this.newInterpolators.size(); ++i) {
                    Interpolator candidate = (Interpolator)this.newInterpolators.elementAt(i);
                    candidate.initialize(now);
                    candidate.finish(now);
                }
                this.activeInterpolators.removeAllElements();
                this.newInterpolators.removeAllElements();
            }
        }
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public boolean isSynchronous() {
        return false;
    }
}

