/*
 * Decompiled with CFR 0.152.
 */
package org.monte.ilbmdemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.monte.media.gui.Worker;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.ILBMDecoder;
import org.monte.media.io.ByteArrayImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ILBMViewer
extends JPanel {
    private Handler handler = new Handler();
    private JLabel label;

    public ILBMViewer() {
        this.initComponents();
        new DropTarget(this, this.handler);
        new DropTarget(this.label, this.handler);
    }

    protected BufferedImage getAmigaPicture(File f) throws IOException {
        return ImageIO.read(f);
    }

    protected BufferedImage getAmigaPictureViaByteArray(File f) throws IOException {
        return this.getAmigaPicture(this.getData(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getData(File f) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(f);
        try {
            byte[] buf = new byte[512];
            int len = in.read(buf);
            while (len != -1) {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    protected BufferedImage getAmigaPicture(byte[] data) throws IOException {
        return ImageIO.read(new ByteArrayImageInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getAmigaPictureWithColorCycling(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            ColorCyclingMemoryImageSource ccmis = new ILBMDecoder(in).produce().get(0);
            if (ccmis.isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(ccmis);
            return image;
        }
        finally {
            in.close();
        }
    }

    public void showILBMImages(final List<File> files) {
        this.label.setEnabled(false);
        if (this.label.getIcon() instanceof ImageIcon) {
            ImageIcon icon = (ImageIcon)this.label.getIcon();
            this.label.setIcon(null);
            this.label.setDisabledIcon(null);
            icon.getImage().flush();
        }
        new Worker<Image>(){

            @Override
            protected Image construct() throws Exception {
                Iterator i$ = files.iterator();
                if (i$.hasNext()) {
                    File f = (File)i$.next();
                    return ILBMViewer.this.getAmigaPictureWithColorCycling(f);
                }
                return null;
            }

            @Override
            protected void done(Image value) {
                if (value == null) {
                    this.failed(new IOException("Could not load image."));
                    return;
                }
                ILBMViewer.this.label.setText(null);
                ImageIcon icon = new ImageIcon(value);
                ILBMViewer.this.label.setIcon(icon);
                ILBMViewer.this.label.setDisabledIcon(icon);
                SwingUtilities.getWindowAncestor(ILBMViewer.this).pack();
            }

            @Override
            protected void failed(Throwable error) {
                ILBMViewer.this.label.setText("<html><b>Error</b><br>" + error.getMessage());
                SwingUtilities.getWindowAncestor(ILBMViewer.this).pack();
            }

            @Override
            protected void finished() {
                ILBMViewer.this.label.setEnabled(true);
            }
        }.start();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.label.setHorizontalAlignment(0);
        this.label.setText("Drop ILBM file here.");
        this.add((Component)this.label, "Center");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f = new JFrame("ILBM Image Viewer");
                f.setDefaultCloseOperation(3);
                f.add(new ILBMViewer());
                f.setSize(200, 200);
                f.setVisible(true);
            }
        });
    }

    private class Handler
    implements DropTargetListener {
        private Handler() {
        }

        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                try {
                    List files = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    ILBMViewer.this.showILBMImages(files);
                }
                catch (IOException e) {
                    JOptionPane.showConfirmDialog(ILBMViewer.this, "Could not access the dropped data.", "ILBMViewer: Drop Failed", -1, 1);
                }
                catch (UnsupportedFlavorException e) {
                    JOptionPane.showConfirmDialog(ILBMViewer.this, "Unsupported data flavor.", "ILBMViewer: Drop Failed", -1, 1);
                }
            } else {
                event.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

