/*
 * Decompiled with CFR 0.152.
 */
package jodd.upload;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jodd.io.FastByteArrayOutputStream;
import jodd.upload.FileUploadHeader;

public class MultipartRequestInputStream
extends BufferedInputStream {
    protected byte[] boundary;
    protected FileUploadHeader lastHeader;

    public MultipartRequestInputStream(InputStream in) {
        super(in);
    }

    public byte readByte() throws IOException {
        int i = super.read();
        if (i == -1) {
            throw new IOException("End of HTTP request stream reached");
        }
        return (byte)i;
    }

    public void skipBytes(int i) throws IOException {
        long len = super.skip(i);
        if (len != (long)i) {
            throw new IOException("Failed to skip data in HTTP request");
        }
    }

    public byte[] readBoundary() throws IOException {
        byte b;
        FastByteArrayOutputStream boundaryOutput = new FastByteArrayOutputStream();
        while ((b = this.readByte()) <= 32) {
        }
        boundaryOutput.write(b);
        while ((b = this.readByte()) != 13) {
            boundaryOutput.write(b);
        }
        if (boundaryOutput.size() == 0) {
            throw new IOException("Problems with parsing request: invalid boundary");
        }
        this.skipBytes(1);
        this.boundary = new byte[boundaryOutput.size() + 2];
        System.arraycopy(boundaryOutput.toByteArray(), 0, this.boundary, 2, this.boundary.length - 2);
        this.boundary[0] = 13;
        this.boundary[1] = 10;
        return this.boundary;
    }

    public FileUploadHeader getLastHeader() {
        return this.lastHeader;
    }

    public FileUploadHeader readDataHeader(String encoding) throws IOException {
        String dataHeader = this.readDataHeaderString(encoding);
        this.lastHeader = dataHeader != null ? new FileUploadHeader(dataHeader) : null;
        return this.lastHeader;
    }

    protected String readDataHeaderString(String encoding) throws IOException {
        FastByteArrayOutputStream data = new FastByteArrayOutputStream();
        while (true) {
            byte b;
            if ((b = this.readByte()) != 13) {
                data.write(b);
                continue;
            }
            this.mark(4);
            this.skipBytes(1);
            int i = this.read();
            if (i == -1) {
                return null;
            }
            if (i == 13) break;
            this.reset();
            data.write(b);
        }
        this.reset();
        this.skipBytes(3);
        if (encoding != null) {
            return data.toString(encoding);
        }
        return data.toString();
    }

    public int copyAll(OutputStream out) throws IOException {
        byte b;
        int count = 0;
        while (!this.isBoundary(b = this.readByte())) {
            out.write(b);
            ++count;
        }
        return count;
    }

    public int copyMax(OutputStream out, int maxBytes) throws IOException {
        byte b;
        int count = 0;
        while (!this.isBoundary(b = this.readByte())) {
            out.write(b);
            if (++count != maxBytes) continue;
            return count;
        }
        return count;
    }

    public int skipToBoundary() throws IOException {
        byte b;
        int count = 0;
        do {
            b = this.readByte();
            ++count;
        } while (!this.isBoundary(b));
        return count;
    }

    public boolean isBoundary(byte b) throws IOException {
        int boundaryLen = this.boundary.length;
        this.mark(boundaryLen + 1);
        int bpos = 0;
        while (b == this.boundary[bpos]) {
            b = this.readByte();
            if (++bpos != boundaryLen) continue;
            return true;
        }
        this.reset();
        return false;
    }
}

