/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import java.util.List;
import jodd.asm.AnnotationVisitorAdapter;
import jodd.asm.EmptyClassVisitor;
import jodd.asm5.AnnotationVisitor;
import jodd.asm5.Attribute;
import jodd.asm5.ClassReader;
import jodd.asm5.ClassVisitor;
import jodd.asm5.FieldVisitor;
import jodd.asm5.MethodVisitor;
import jodd.proxetta.JoddProxetta;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaCtorBuilder;
import jodd.proxetta.asm.ProxettaMethodBuilder;
import jodd.proxetta.asm.ProxyAspectData;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxettaClassBuilder
extends EmptyClassVisitor {
    protected final ProxyAspect[] aspects;
    protected final String suffix;
    protected final String reqProxyClassName;
    protected final TargetClassInfoReader targetClassInfo;
    protected final WorkData wd;

    public ProxettaClassBuilder(ClassVisitor dest, ProxyAspect[] aspects, String suffix, String reqProxyClassName, TargetClassInfoReader targetClassInfoReader) {
        this.wd = new WorkData(dest);
        this.aspects = aspects;
        this.suffix = suffix;
        this.reqProxyClassName = reqProxyClassName;
        this.targetClassInfo = targetClassInfoReader;
    }

    public WorkData getWorkData() {
        return this.wd;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.wd.init(name, superName, this.suffix, this.reqProxyClassName);
        this.wd.dest.visit(version, access &= 0xFFFFFBFF, this.wd.thisReference, signature, this.wd.superName, null);
        this.wd.proxyAspects = new ProxyAspectData[this.aspects.length];
        for (int i = 0; i < this.aspects.length; ++i) {
            this.wd.proxyAspects[i] = new ProxyAspectData(this.wd, this.aspects[i], i);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodSignatureVisitor msign = this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.wd.superReference);
        if (msign == null) {
            return null;
        }
        if (name.equals("<init>")) {
            MethodVisitor mv = this.wd.dest.visitMethod(access, name, desc, msign.getRawSignature(), null);
            return new ProxettaCtorBuilder(mv, msign, this.wd);
        }
        if (name.equals("<clinit>")) {
            return null;
        }
        return this.applyProxy(msign);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor destAnn = this.wd.dest.visitAnnotation(desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public void visitEnd() {
        this.makeStaticInitBlock();
        this.makeProxyConstructor();
        this.processSuperMethods();
        this.wd.dest.visitEnd();
    }

    protected void makeStaticInitBlock() {
        if (this.wd.adviceClinits != null) {
            MethodVisitor mv = this.wd.dest.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            for (String name : this.wd.adviceClinits) {
                mv.visitMethodInsn(184, this.wd.thisReference, name, "()V");
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected void makeProxyConstructor() {
        MethodVisitor mv = this.wd.dest.visitMethod(18, JoddProxetta.initMethodName, "()V", null, null);
        mv.visitCode();
        if (this.wd.adviceInits != null) {
            for (String name : this.wd.adviceInits) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.wd.thisReference, name, "()V");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void processSuperMethods() {
        for (ClassReader cr : this.targetClassInfo.superClassReaders) {
            cr.accept(new EmptyClassVisitor(){
                String declaredClassName;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.declaredClassName = name;
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.equals("<init>") || name.equals("<clinit>")) {
                        return null;
                    }
                    MethodSignatureVisitor msign = ProxettaClassBuilder.this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.declaredClassName);
                    if (msign == null) {
                        return null;
                    }
                    return ProxettaClassBuilder.this.applyProxy(msign);
                }
            }, 0);
        }
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    protected ProxettaMethodBuilder applyProxy(MethodSignatureVisitor msign) {
        List<ProxyAspectData> aspectList = this.matchMethodPointcuts(msign);
        if (aspectList == null) {
            return null;
        }
        int access = msign.getAccessFlags();
        if ((access & 0x400) != 0) {
            throw new ProxettaException("Unable to process abstract method: " + msign);
        }
        this.wd.proxyApplied = true;
        return new ProxettaMethodBuilder(msign, this.wd, aspectList);
    }

    protected List<ProxyAspectData> matchMethodPointcuts(MethodSignatureVisitor msign) {
        ArrayList<ProxyAspectData> aspectList = null;
        for (ProxyAspectData aspectData : this.wd.proxyAspects) {
            if (!aspectData.apply(msign)) continue;
            if (aspectList == null) {
                aspectList = new ArrayList<ProxyAspectData>(this.wd.proxyAspects.length);
            }
            aspectList.add(aspectData);
        }
        return aspectList;
    }
}

