/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import jodd.asm.ClassAdapter;
import jodd.asm5.ClassVisitor;
import jodd.asm5.MethodVisitor;
import jodd.proxetta.InvokeAspect;
import jodd.proxetta.asm.InvokeReplacerMethodAdapter;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;

public class InvokeClassBuilder
extends ClassAdapter {
    protected final WorkData wd;
    protected final InvokeAspect[] aspects;
    protected final String suffix;
    protected final String reqProxyClassName;
    protected final TargetClassInfoReader targetClassInfo;

    public InvokeClassBuilder(ClassVisitor dest, InvokeAspect[] invokeAspects, String suffix, String reqProxyClassName, TargetClassInfoReader targetClassInfoReader) {
        super(dest);
        this.aspects = invokeAspects;
        this.suffix = suffix;
        this.wd = new WorkData(dest);
        this.targetClassInfo = targetClassInfoReader;
        this.reqProxyClassName = reqProxyClassName;
    }

    public WorkData getWorkData() {
        return this.wd;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.wd.init(name, superName, this.suffix, this.reqProxyClassName);
        super.visit(version, access, this.wd.thisReference, signature, this.wd.superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodSignatureVisitor msign = this.targetClassInfo.lookupMethodSignatureVisitor(access, name, desc, this.wd.superReference);
        if (msign == null) {
            super.visitMethod(access, name, desc, signature, exceptions);
            return null;
        }
        ArrayList<InvokeAspect> applicableAspects = new ArrayList<InvokeAspect>(this.aspects.length);
        for (InvokeAspect aspect : this.aspects) {
            if (!aspect.apply(msign)) continue;
            applicableAspects.add(aspect);
        }
        if (applicableAspects.isEmpty()) {
            super.visitMethod(access, name, desc, signature, exceptions);
            return null;
        }
        InvokeAspect[] nextAspects = new InvokeAspect[applicableAspects.size()];
        nextAspects = applicableAspects.toArray(nextAspects);
        return new InvokeReplacerMethodAdapter(super.visitMethod(access, name, desc, signature, exceptions), msign, this.wd, nextAspects);
    }
}

