/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteUtil;
import jodd.petite.scope.Scope;

public class SingletonScope
implements Scope {
    protected Map<String, BeanData> instances = new HashMap<String, BeanData>();

    public Object lookup(String name) {
        BeanData beanData = this.instances.get(name);
        if (beanData == null) {
            return null;
        }
        return beanData.getBean();
    }

    public void register(BeanDefinition beanDefinition, Object bean) {
        BeanData beanData = new BeanData(beanDefinition, bean);
        this.instances.put(beanDefinition.getName(), beanData);
    }

    public void remove(String name) {
        this.instances.remove(name);
    }

    public boolean accept(Scope referenceScope) {
        return referenceScope.getClass() == SingletonScope.class;
    }

    public void shutdown() {
        for (BeanData beanData : this.instances.values()) {
            PetiteUtil.callDestroyMethods(beanData);
        }
        this.instances.clear();
    }
}

