/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteException;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SessionScope;
import jodd.petite.scope.SingletonScope;
import jodd.servlet.RequestContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestScope
implements Scope {
    protected static final String ATTR_NAME = RequestScope.class.getName() + ".MAP.";

    protected Map<String, BeanData> getRequestMap(HttpServletRequest servletRequest) {
        return (Map)servletRequest.getAttribute(ATTR_NAME);
    }

    protected void removeRequestMap(HttpServletRequest servletRequest) {
        servletRequest.removeAttribute(ATTR_NAME);
    }

    protected Map<String, BeanData> createRequestMap(HttpServletRequest servletRequest) {
        HashMap<String, BeanData> map = new HashMap<String, BeanData>();
        servletRequest.setAttribute(ATTR_NAME, map);
        return map;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object lookup(String name) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, BeanData> map = this.getRequestMap(servletRequest);
        if (map == null) {
            return null;
        }
        BeanData beanData = map.get(name);
        if (beanData == null) {
            return null;
        }
        return beanData.getBean();
    }

    @Override
    public void register(BeanDefinition beanDefinition, Object bean) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, BeanData> map = this.getRequestMap(servletRequest);
        if (map == null) {
            map = this.createRequestMap(servletRequest);
        }
        BeanData beanData = new BeanData(beanDefinition, bean);
        map.put(beanDefinition.getName(), beanData);
    }

    @Override
    public void remove(String name) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, BeanData> map = this.getRequestMap(servletRequest);
        if (map != null) {
            map.remove(name);
        }
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == SingletonScope.class) {
            return true;
        }
        if (refScopeType == SessionScope.class) {
            return true;
        }
        return refScopeType == RequestScope.class;
    }

    protected HttpServletRequest getCurrentHttpRequest() {
        HttpServletRequest request = RequestContextListener.getRequest();
        if (request == null) {
            throw new PetiteException("No HTTP request bound to the current thread. Is RequestContextListener registered?");
        }
        return request;
    }
}

