/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import jodd.mail.SmtpServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpSslServer
extends SmtpServer<SmtpSslServer> {
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 465;

    public static SmtpSslServer create(String host) {
        return new SmtpSslServer(host, 465);
    }

    public static SmtpSslServer create(String host, int port) {
        return new SmtpSslServer(host, port);
    }

    public SmtpSslServer(String host) {
        super(host, 465);
    }

    public SmtpSslServer(String host, int port) {
        super(host, port);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty(MAIL_SMTP_STARTTLS_ENABLE, "true");
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_PORT, String.valueOf(this.port));
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        props.setProperty("mail.host", this.host);
        return props;
    }
}

