/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jodd.core.JoddCore;
import jodd.mail.EmailAddress;
import jodd.util.StringUtil;

public class MailAddress {
    public static final MailAddress[] EMPTY_ARRAY = new MailAddress[0];
    private final String email;
    private final String personalName;

    public MailAddress(String personalName, String email) {
        this.email = email;
        this.personalName = personalName;
    }

    public MailAddress(String address) {
        address = address.trim();
        if (!StringUtil.endsWithChar(address, '>')) {
            this.email = address;
            this.personalName = null;
            return;
        }
        int ndx = address.lastIndexOf(60);
        if (ndx == -1) {
            this.email = address;
            this.personalName = null;
            return;
        }
        this.email = address.substring(ndx + 1, address.length() - 1);
        this.personalName = address.substring(0, ndx - 1).trim();
    }

    public MailAddress(EmailAddress emailAddress) {
        this.personalName = emailAddress.getPersonalName();
        this.email = emailAddress.getLocalPart() + '@' + emailAddress.getDomain();
    }

    public MailAddress(InternetAddress internetAddress) {
        this.personalName = internetAddress.getPersonal();
        this.email = internetAddress.getAddress();
    }

    public MailAddress(Address address) {
        this(address.toString());
    }

    public String getEmail() {
        return this.email;
    }

    public String getPersonalName() {
        return this.personalName;
    }

    public EmailAddress toEmailAddress() {
        return new EmailAddress(this.toString());
    }

    public InternetAddress toInternetAddress() throws AddressException {
        try {
            return new InternetAddress(this.email, this.personalName, JoddCore.encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new AddressException(ueex.toString());
        }
    }

    public String toString() {
        if (this.personalName == null) {
            return this.email;
        }
        return this.personalName + " <" + this.email + '>';
    }

    public static MailAddress[] createFrom(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        MailAddress[] res = new MailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = new MailAddress(addresses[i]);
        }
        return res;
    }

    public static MailAddress[] createFrom(String[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        MailAddress[] res = new MailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = new MailAddress(addresses[i]);
        }
        return res;
    }

    public static MailAddress[] createFrom(EmailAddress[] addresses) {
        if (addresses == null) {
            return null;
        }
        if (addresses.length == 0) {
            return null;
        }
        MailAddress[] res = new MailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = new MailAddress(addresses[i]);
        }
        return res;
    }
}

