/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.net.MalformedURLException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.result.AbstractTemplateViewResult;
import jodd.servlet.DispatcherUtil;

public class ServletDispatcherResult
extends AbstractTemplateViewResult {
    private static final Logger log = LoggerFactory.getLogger(ServletDispatcherResult.class);
    public static final String NAME = "dispatch";
    protected String[] extensions = new String[]{".jspf", ".jsp"};

    public ServletDispatcherResult() {
        super(NAME);
    }

    protected void renderView(ActionRequest actionRequest, String target) throws Exception {
        target = this.processTarget(actionRequest, target);
        HttpServletRequest request = actionRequest.getHttpServletRequest();
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        RequestDispatcher dispatcher = request.getRequestDispatcher(target);
        if (dispatcher == null) {
            response.sendError(404, "Result not found: " + target);
            return;
        }
        if (DispatcherUtil.isPageIncluded(request, response)) {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String locateTarget(ActionRequest actionRequest, String path) {
        for (String ext : this.extensions) {
            String target = path + ext;
            if (!this.targetExists(actionRequest, target)) continue;
            return target;
        }
        return null;
    }

    protected boolean targetExists(ActionRequest actionRequest, String target) {
        if (log.isDebugEnabled()) {
            log.debug("target check: " + target);
        }
        ServletContext servletContext = actionRequest.getHttpServletRequest().getSession().getServletContext();
        try {
            return servletContext.getResource(target) != null;
        }
        catch (MalformedURLException ignore) {
            return false;
        }
    }

    protected String processTarget(ActionRequest actionRequest, String target) {
        return target;
    }
}

