/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import javax.servlet.http.HttpServletRequest;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.InjectorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.interceptor.BaseActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;

public class ServletConfigInterceptor
extends BaseActionInterceptor {
    @In(scope=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;
    @In(scope=ScopeType.CONTEXT)
    protected InjectorsManager injectorsManager;

    public Object intercept(ActionRequest actionRequest) throws Exception {
        Object servletRequest = actionRequest.getHttpServletRequest();
        if (ServletUtil.isMultipartRequest(servletRequest)) {
            servletRequest = new MultipartRequestWrapper((HttpServletRequest)servletRequest, this.madvocConfig.getFileUploadFactory(), this.madvocConfig.getEncoding());
            actionRequest.setHttpServletRequest((HttpServletRequest)servletRequest);
        }
        this.inject(actionRequest);
        Object result = actionRequest.invoke();
        this.outject(actionRequest);
        return result;
    }

    protected void inject(ActionRequest actionRequest) {
        this.injectorsManager.getMadvocContextScopeInjector().inject(actionRequest);
        this.injectorsManager.getServletContextScopeInjector().inject(actionRequest);
        this.injectorsManager.getApplicationScopeInjector().inject(actionRequest);
        this.injectorsManager.getSessionScopeInjector().inject(actionRequest);
        this.injectorsManager.getRequestScopeInjector().prepare(actionRequest);
        this.injectorsManager.getRequestScopeInjector().inject(actionRequest);
        this.injectorsManager.getActionPathMacroInjector().inject(actionRequest);
    }

    protected void outject(ActionRequest actionRequest) {
        this.injectorsManager.getServletContextScopeInjector().outject(actionRequest);
        this.injectorsManager.getApplicationScopeInjector().outject(actionRequest);
        this.injectorsManager.getSessionScopeInjector().outject(actionRequest);
        this.injectorsManager.getRequestScopeInjector().outject(actionRequest);
    }
}

