/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.injector.Target;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.Out;
import jodd.madvoc.result.Result;

public class ActionRequest {
    protected final MadvocController madvocController;
    protected final ActionConfig actionConfig;
    protected final String actionPath;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Result result;
    protected final Target[] targets;
    protected final int totalInterceptors;
    protected int interceptorIndex;
    protected int filterIndex;
    protected int totalFilters;
    protected int execState;
    protected Object action;
    protected Object actionResult;
    protected String nextActionPath;
    protected ActionRequest previousActionRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public ActionRequest getPreviousActionRequest() {
        return this.previousActionRequest;
    }

    public void setPreviousActionRequest(ActionRequest previousActionRequest) {
        this.previousActionRequest = previousActionRequest;
    }

    public Result getResult() {
        return this.result;
    }

    public Target[] getTargets() {
        return this.targets;
    }

    public Object getActionResult() {
        return this.actionResult;
    }

    public void setActionResult(Object actionResult) {
        this.actionResult = actionResult;
    }

    public ActionRequest(MadvocController madvocController, String actionPath, ActionConfig actionConfig, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.madvocController = madvocController;
        this.actionPath = actionPath;
        this.actionConfig = actionConfig;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.totalInterceptors = this.actionConfig.interceptors != null ? this.actionConfig.interceptors.length : 0;
        this.interceptorIndex = 0;
        this.totalFilters = this.actionConfig.filters != null ? this.actionConfig.filters.length : 0;
        this.filterIndex = 0;
        this.execState = 0;
        this.action = action;
        this.result = this.findResult();
        this.targets = this.makeTargets();
    }

    protected Result findResult() {
        Field resultField = this.actionConfig.resultField;
        if (resultField != null) {
            try {
                Result result = (Result)resultField.get(this.action);
                if (result == null) {
                    result = (Result)resultField.getType().newInstance();
                    resultField.set(this.action, result);
                }
                return result;
            }
            catch (Exception ignore) {
                return null;
            }
        }
        return null;
    }

    protected Target[] makeTargets() {
        if (!this.actionConfig.hasArguments) {
            return new Target[]{new Target(this.action)};
        }
        ActionConfig.MethodParam[] methodParams = this.actionConfig.getMethodParams();
        Target[] target = new Target[methodParams.length + 1];
        target[0] = new Target(this.action);
        for (int i = 0; i < methodParams.length; ++i) {
            ActionConfig.MethodParam mp = methodParams[i];
            Class type = mp.getType();
            Target t = mp.getAnnotationType() == null ? new Target(this.createActionMethodArgument(type)) : (mp.getAnnotationType() == Out.class ? new Target(this.createActionMethodArgument(type), type) : new Target(type){

                protected void createValueInstance() {
                    this.value = ActionRequest.this.createActionMethodArgument(this.type);
                }
            });
            target[i + 1] = t;
        }
        return target;
    }

    protected Object createActionMethodArgument(Class type) {
        try {
            if (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers())) {
                Constructor ctor = type.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            Constructor ctor = type.getDeclaredConstructor(type.getDeclaringClass());
            ctor.setAccessible(true);
            return ctor.newInstance(this.action);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }

    public Object invoke() throws Exception {
        Object actionResult;
        if (this.execState >= 2) {
            throw new MadvocException("Action already invoked: " + this.actionConfig.actionPath);
        }
        if (this.execState == 0 && this.filterIndex < this.totalFilters) {
            ActionFilter filter = this.actionConfig.filters[this.filterIndex];
            ++this.filterIndex;
            return filter.invoke(this);
        }
        this.execState = 1;
        try {
            actionResult = this.invokeAction();
        }
        catch (Exception ex) {
            --this.interceptorIndex;
            throw ex;
        }
        if (this.execState == 2) {
            if (this.interceptorIndex > 0) {
                --this.interceptorIndex;
            } else {
                this.madvocController.render(this, actionResult);
                this.execState = 3;
            }
        } else if (this.execState == 1) {
            if (this.interceptorIndex > 1) {
                --this.interceptorIndex;
            } else {
                this.madvocController.render(this, actionResult);
                this.execState = 3;
            }
        }
        return actionResult;
    }

    protected Object invokeAction() throws Exception {
        if (this.interceptorIndex < this.totalInterceptors) {
            ActionInterceptor interceptor = this.actionConfig.interceptors[this.interceptorIndex];
            ++this.interceptorIndex;
            return interceptor.invoke(this);
        }
        this.execState = 2;
        return this.invokeActionMethod();
    }

    protected Object invokeActionMethod() throws Exception {
        Object[] params = this.extractParametersFromTargets();
        try {
            return this.actionConfig.actionClassMethod.invoke(this.action, params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.extractTargetException(itex);
        }
    }

    protected Object[] extractParametersFromTargets() {
        if (this.targets == null) {
            return null;
        }
        Object[] values = new Object[this.targets.length - 1];
        for (int i = 1; i < this.targets.length; ++i) {
            values[i - 1] = this.targets[i].getValue();
        }
        return values;
    }
}

