/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import jodd.lagarto.Doctype;
import jodd.lagarto.LagartoException;
import jodd.lagarto.Tag;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.TagWriterUtil;
import jodd.util.HtmlEncoder;

public class TagWriter
implements TagVisitor {
    protected Appendable appendable;

    public TagWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    public void setOutput(Appendable out) {
        this.appendable = out;
    }

    public Appendable getOutput() {
        return this.appendable;
    }

    public void start() {
    }

    public void end() {
    }

    public void tag(Tag tag) {
        try {
            tag.writeTo(this.appendable);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void script(Tag tag, CharSequence body) {
        try {
            tag.writeTo(this.appendable);
            if (body != null) {
                this.appendable.append(body);
            }
            this.appendable.append("</script>");
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void comment(CharSequence comment) {
        try {
            TagWriterUtil.writeComment(this.appendable, comment);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void text(CharSequence text) {
        try {
            this.appendable.append(HtmlEncoder.text(text));
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void cdata(CharSequence cdata) {
        try {
            TagWriterUtil.writeCData(this.appendable, cdata);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void xml(CharSequence version, CharSequence encoding, CharSequence standalone) {
        try {
            TagWriterUtil.writeXml(this.appendable, version, encoding, standalone);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void doctype(Doctype doctype) {
        try {
            TagWriterUtil.writeDoctype(this.appendable, doctype.getName(), doctype.getPublicIdentifier(), doctype.getSystemIdentifier());
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
        try {
            TagWriterUtil.writeConditionalComment(this.appendable, expression, isStartingTag, isHidden, isHiddenEndTag);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void error(String message) {
    }
}

