/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.jtx.JtxException;
import jodd.jtx.JtxIsolationLevel;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxStatus;
import jodd.jtx.JtxTransaction;
import jodd.jtx.JtxTransactionMode;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtxTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(JtxTransactionManager.class);
    protected int maxResourcesPerTransaction = -1;
    protected boolean oneResourceManager;
    protected boolean validateExistingTransaction;
    protected boolean ignoreScope;
    protected Map<Class, JtxResourceManager> resourceManagers;
    protected final ThreadLocal<ArrayList<JtxTransaction>> txStack = new ThreadLocal();
    protected int totalTransactions;

    public JtxTransactionManager() {
        this.resourceManagers = new HashMap<Class, JtxResourceManager>();
    }

    public int getMaxResourcesPerTransaction() {
        return this.maxResourcesPerTransaction;
    }

    public void setMaxResourcesPerTransaction(int maxResourcesPerTransaction) {
        this.maxResourcesPerTransaction = maxResourcesPerTransaction;
    }

    public boolean isValidateExistingTransaction() {
        return this.validateExistingTransaction;
    }

    public void setValidateExistingTransaction(boolean validateExistingTransaction) {
        this.validateExistingTransaction = validateExistingTransaction;
    }

    public boolean isSingleResourceManager() {
        return this.oneResourceManager;
    }

    public void setSingleResourceManager(boolean oneResourceManager) {
        this.oneResourceManager = oneResourceManager;
    }

    public boolean isIgnoreScope() {
        return this.ignoreScope;
    }

    public void setIgnoreScope(boolean ignoreScope) {
        this.ignoreScope = ignoreScope;
    }

    public int totalThreadTransactions() {
        ArrayList<JtxTransaction> txList = this.txStack.get();
        if (txList == null) {
            return 0;
        }
        return txList.size();
    }

    public int totalThreadTransactionsWithStatus(JtxStatus status) {
        ArrayList<JtxTransaction> txlist = this.txStack.get();
        if (txlist == null) {
            return 0;
        }
        int count = 0;
        for (JtxTransaction tx : txlist) {
            if (tx.getStatus() != status) continue;
            ++count;
        }
        return count;
    }

    public int totalActiveThreadTransactions() {
        return this.totalThreadTransactionsWithStatus(JtxStatus.STATUS_ACTIVE);
    }

    public boolean isAssociatedWithThread(JtxTransaction tx) {
        ArrayList<JtxTransaction> txList = this.txStack.get();
        if (txList == null) {
            return false;
        }
        return txList.contains(tx);
    }

    protected boolean removeTransaction(JtxTransaction tx) {
        ArrayList<JtxTransaction> txList = this.txStack.get();
        if (txList == null) {
            return false;
        }
        boolean removed = txList.remove(tx);
        if (removed) {
            --this.totalTransactions;
        }
        if (txList.isEmpty()) {
            this.txStack.remove();
        }
        return removed;
    }

    public JtxTransaction getTransaction() {
        ArrayList<JtxTransaction> txlist = this.txStack.get();
        if (txlist == null) {
            return null;
        }
        if (txlist.isEmpty()) {
            return null;
        }
        return txlist.get(txlist.size() - 1);
    }

    protected void associateTransaction(JtxTransaction tx) {
        ++this.totalTransactions;
        ArrayList<JtxTransaction> txList = this.txStack.get();
        if (txList == null) {
            txList = new ArrayList();
            this.txStack.set(txList);
        }
        txList.add(tx);
    }

    public int totalTransactions() {
        return this.totalTransactions;
    }

    protected JtxTransaction createNewTransaction(JtxTransactionMode tm, Object scope, boolean active) {
        return new JtxTransaction(this, tm, scope, active);
    }

    public JtxTransaction requestTransaction(JtxTransactionMode mode) {
        return this.requestTransaction(mode, null);
    }

    public JtxTransaction requestTransaction(JtxTransactionMode mode, Object scope) {
        JtxTransaction currentTx;
        if (log.isDebugEnabled()) {
            log.debug("Requesting TX " + mode.toString());
        }
        if (!this.isNewTxScope(currentTx = this.getTransaction(), scope)) {
            return currentTx;
        }
        switch (mode.getPropagationBehavior()) {
            case PROPAGATION_REQUIRED: {
                return this.propRequired(currentTx, mode, scope);
            }
            case PROPAGATION_SUPPORTS: {
                return this.propSupports(currentTx, mode, scope);
            }
            case PROPAGATION_MANDATORY: {
                return this.propMandatory(currentTx, mode, scope);
            }
            case PROPAGATION_REQUIRES_NEW: {
                return this.propRequiresNew(currentTx, mode, scope);
            }
            case PROPAGATION_NOT_SUPPORTED: {
                return this.propNotSupported(currentTx, mode, scope);
            }
            case PROPAGATION_NEVER: {
                return this.propNever(currentTx, mode, scope);
            }
        }
        throw new JtxException("Invalid TX propagation value: " + mode.getPropagationBehavior().value());
    }

    protected boolean isNewTxScope(JtxTransaction currentTx, Object destScope) {
        if (this.ignoreScope) {
            return true;
        }
        if (currentTx == null) {
            return true;
        }
        if (destScope == null) {
            return true;
        }
        if (currentTx.getScope() == null) {
            return true;
        }
        return !destScope.equals(currentTx.getScope());
    }

    protected void continueTx(JtxTransaction sourceTx, JtxTransactionMode destMode) {
        JtxIsolationLevel currentIsolationLevel;
        if (!this.validateExistingTransaction) {
            return;
        }
        JtxTransactionMode sourceMode = sourceTx.getTransactionMode();
        JtxIsolationLevel destIsolationLevel = destMode.getIsolationLevel();
        if (destIsolationLevel != JtxIsolationLevel.ISOLATION_DEFAULT && (currentIsolationLevel = sourceMode.getIsolationLevel()) != destIsolationLevel) {
            throw new JtxException("Participating TX specifies isolation level: " + (Object)((Object)destIsolationLevel) + " which is incompatible with existing TX: " + (Object)((Object)currentIsolationLevel));
        }
        if (!destMode.isReadOnly() && sourceMode.isReadOnly()) {
            throw new JtxException("Participating TX is not marked as read-only, but existing TX is");
        }
    }

    protected JtxTransaction propRequired(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        if (currentTx == null || currentTx.isNoTransaction()) {
            currentTx = this.createNewTransaction(mode, scope, true);
        } else {
            this.continueTx(currentTx, mode);
        }
        return currentTx;
    }

    protected JtxTransaction propRequiresNew(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        return this.createNewTransaction(mode, scope, true);
    }

    protected JtxTransaction propSupports(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        if (currentTx != null && !currentTx.isNoTransaction()) {
            this.continueTx(currentTx, mode);
        }
        if (currentTx == null) {
            currentTx = this.createNewTransaction(mode, scope, false);
        }
        return currentTx;
    }

    protected JtxTransaction propMandatory(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        if (currentTx == null || currentTx.isNoTransaction()) {
            throw new JtxException("No existing TX found for TX marked with propagation 'mandatory'");
        }
        this.continueTx(currentTx, mode);
        return currentTx;
    }

    protected JtxTransaction propNotSupported(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        if (currentTx == null) {
            return this.createNewTransaction(mode, scope, false);
        }
        if (currentTx.isNoTransaction()) {
            return currentTx;
        }
        return this.createNewTransaction(mode, scope, false);
    }

    protected JtxTransaction propNever(JtxTransaction currentTx, JtxTransactionMode mode, Object scope) {
        if (currentTx != null && !currentTx.isNoTransaction()) {
            throw new JtxException("Existing TX found for TX marked with propagation 'never'");
        }
        if (currentTx == null) {
            currentTx = this.createNewTransaction(mode, scope, false);
        }
        return currentTx;
    }

    public void registerResourceManager(JtxResourceManager resourceManager) {
        if (this.oneResourceManager && !this.resourceManagers.isEmpty()) {
            throw new JtxException("TX manager allows only one resource manager");
        }
        this.resourceManagers.put(resourceManager.getResourceType(), resourceManager);
    }

    protected <E> JtxResourceManager<E> lookupResourceManager(Class<E> resourceType) {
        JtxResourceManager resourceManager = this.resourceManagers.get(resourceType);
        if (resourceManager == null) {
            throw new JtxException("No registered resource manager for resource type: " + resourceType.getSimpleName());
        }
        return resourceManager;
    }

    public void close() {
        for (JtxResourceManager resourceManager : this.resourceManagers.values()) {
            try {
                resourceManager.close();
            }
            catch (Exception exception) {}
        }
        this.resourceManagers.clear();
    }
}

