/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;
import jodd.json.JsonException;
import jodd.json.JsonParserBase;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToBean {
    protected boolean declared = true;
    protected final JsonParserBase jsonParser;
    protected final String classMetadataName;

    public MapToBean(JsonParserBase jsonParser, String classMetadataName) {
        this.jsonParser = jsonParser;
        this.classMetadataName = classMetadataName;
    }

    public Object map2bean(Map map, Class targetType) {
        Object target = null;
        String className = (String)map.get(this.classMetadataName);
        if (className == null) {
            if (targetType == null) {
                target = map;
            }
        } else {
            try {
                targetType = ClassLoaderUtil.loadClass(className);
            }
            catch (ClassNotFoundException cnfex) {
                throw new JsonException(cnfex);
            }
        }
        if (target == null) {
            target = this.jsonParser.newObjectInstance(targetType);
        }
        ClassDescriptor cd = ClassIntrospector.lookup(target.getClass());
        boolean targetIsMap = target instanceof Map;
        for (Object key : map.keySet()) {
            Class componentType;
            String keyName = key.toString();
            if (this.classMetadataName != null && keyName.equals(this.classMetadataName)) continue;
            PropertyDescriptor pd = cd.getPropertyDescriptor(keyName, this.declared);
            if (!targetIsMap && pd == null) continue;
            Object value = map.get(key);
            Class propertyType = pd == null ? null : pd.getType();
            Class clazz = componentType = pd == null ? null : pd.resolveComponentType(true);
            if (value != null) {
                if (value instanceof List) {
                    if (componentType != null && componentType != String.class) {
                        value = this.generifyList((List)value, componentType);
                    }
                } else if (value instanceof Map) {
                    if (!ReflectUtil.isTypeOf(propertyType, Map.class)) {
                        value = this.map2bean((Map)value, propertyType);
                    } else {
                        Class keyType;
                        Class clazz2 = keyType = pd == null ? null : pd.resolveKeyType(true);
                        if (keyType != String.class || componentType != String.class) {
                            value = this.generifyMap((Map)value, keyType, componentType);
                        }
                    }
                }
            }
            if (targetIsMap) {
                ((Map)target).put(keyName, value);
                continue;
            }
            try {
                this.setValue(target, pd, value);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
        return target;
    }

    private Object generifyList(List list, Class componentType) {
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element == null) continue;
            if (element instanceof Map) {
                Object bean = this.map2bean((Map)element, componentType);
                list.set(i, bean);
                continue;
            }
            Object value = this.convert(element, componentType);
            list.set(i, value);
        }
        return list;
    }

    private void setValue(Object target, PropertyDescriptor pd, Object value) throws InvocationTargetException, IllegalAccessException {
        Setter setter = pd.getSetter(true);
        if (setter != null) {
            if (value != null) {
                Class propertyType = setter.getSetterRawType();
                value = this.jsonParser.convertType(value, propertyType);
            }
            setter.invokeSetter(target, value);
        }
    }

    protected <K, V> Map<K, V> generifyMap(Map<Object, Object> map, Class<K> keyType, Class<V> valueType) {
        if (keyType == String.class) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object newValue;
                Object value = entry.getValue();
                if (value == (newValue = this.convert(value, valueType))) continue;
                entry.setValue(newValue);
            }
            return map;
        }
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object newKey = this.convert(key, keyType);
            Object value = entry.getValue();
            Object newValue = this.convert(value, valueType);
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    protected Object convert(Object value, Class targetType) {
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return value;
        }
        if (value instanceof Map) {
            if (targetType == Map.class) {
                return value;
            }
            return this.map2bean((Map)value, targetType);
        }
        try {
            return TypeConverterManager.convertType(value, targetType);
        }
        catch (Exception ex) {
            throw new JsonException("Type conversion failed", ex);
        }
    }
}

