/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.CtorDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;
import jodd.json.JsonException;
import jodd.json.MapToBean;
import jodd.typeconverter.TypeConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonParserBase {
    protected MapToBean createMapToBean(String classMetadataName) {
        return new MapToBean(this, classMetadataName);
    }

    protected List<Object> newArrayInstance(Class targetType) {
        if (targetType == null || targetType == List.class || targetType.isArray()) {
            return new ArrayList<Object>();
        }
        try {
            return (List)targetType.newInstance();
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected Object newObjectInstance(Class targetType) {
        if (targetType == null) {
            return new HashMap();
        }
        if (targetType == Map.class) {
            return new HashMap();
        }
        ClassDescriptor cd = ClassIntrospector.lookup(targetType);
        CtorDescriptor ctorDescriptor = cd.getDefaultCtorDescriptor(true);
        if (ctorDescriptor == null) {
            throw new JsonException("Default ctor not found for: " + targetType.getClass().getName());
        }
        try {
            return ctorDescriptor.getConstructor().newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    protected void injectValueIntoObject(Object target, PropertyDescriptor pd, Object value) {
        Object convertedValue = value;
        if (value != null) {
            Class targetClass = pd.getType();
            convertedValue = this.convertType(value, targetClass);
        }
        try {
            Setter setter = pd.getSetter(true);
            if (setter != null) {
                setter.invokeSetter(target, convertedValue);
            }
        }
        catch (Exception ex) {
            throw new JsonException(ex);
        }
    }

    protected Object convertType(Object value, Class targetType) {
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return value;
        }
        try {
            return TypeConverterManager.convertType(value, targetType);
        }
        catch (Exception ex) {
            throw new JsonException("Type conversion failed", ex);
        }
    }
}

