/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora.parser;

import java.util.LinkedList;
import jodd.decora.DecoraException;
import jodd.decora.parser.DecoraTag;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;

public class PageRegionExtractor
extends EmptyTagVisitor {
    protected final DecoraTag[] decoraTags;
    protected LinkedList<RegionMarker> regionMarkers = new LinkedList();

    public PageRegionExtractor(DecoraTag[] decoraTags) {
        this.decoraTags = decoraTags;
    }

    public void tag(Tag tag) {
        if (tag.getType() == TagType.END) {
            if (!this.regionMarkers.isEmpty()) {
                RegionMarker regionMarker = this.regionMarkers.getLast();
                if (tag.nameEquals(regionMarker.name)) {
                    --regionMarker.innerCount;
                }
                if (regionMarker.innerCount <= 0) {
                    for (DecoraTag decoraTag : this.decoraTags) {
                        if (!decoraTag.isRegionStarted() || !tag.nameEquals(decoraTag.getName())) continue;
                        decoraTag.endRegion(tag.getTagPosition(), tag.getTagLength());
                        this.regionMarkers.removeLast();
                        return;
                    }
                    throw new DecoraException("Region end is not aligned: " + tag.getName());
                }
            }
            return;
        }
        if (tag.getType() == TagType.SELF_CLOSING) {
            return;
        }
        for (DecoraTag decoraTag : this.decoraTags) {
            if (!decoraTag.isRegionUndefined() || !decoraTag.isMatchedTag(tag)) continue;
            decoraTag.startRegion(tag.getTagPosition(), tag.getTagLength(), tag.getDeepLevel());
            RegionMarker regionMarker = new RegionMarker(tag.getName());
            this.regionMarkers.add(regionMarker);
            break;
        }
        if (!this.regionMarkers.isEmpty()) {
            RegionMarker regionMarker = this.regionMarkers.getLast();
            if (tag.nameEquals(regionMarker.name)) {
                ++regionMarker.innerCount;
            }
        }
    }

    public void end() {
        if (!this.regionMarkers.isEmpty()) {
            throw new DecoraException("Invalid regions detected: " + this.regionMarkers.getLast().name);
        }
    }

    public static class RegionMarker {
        public final CharSequence name;
        public int innerCount;

        public RegionMarker(CharSequence name) {
            this.name = name;
            this.innerCount = 0;
        }
    }
}

