/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlType<T> {
    public static final int DB_SQLTYPE_UNKNOWN = Integer.MAX_VALUE;
    public static final int DB_SQLTYPE_NOT_AVAILABLE = Integer.MIN_VALUE;
    protected Class<T> sqlType = ReflectUtil.getGenericSupertype(this.getClass());

    protected SqlType() {
    }

    public abstract void set(PreparedStatement var1, int var2, T var3, int var4) throws SQLException;

    public abstract T get(ResultSet var1, int var2, int var3) throws SQLException;

    public void storeValue(PreparedStatement st, int index, Object value, int dbSqlType) throws SQLException {
        T t = TypeConverterManager.convertType(value, this.sqlType);
        this.set(st, index, t, dbSqlType);
    }

    public <E> E readValue(ResultSet rs, int index, Class<E> destinationType, int dbSqlType) throws SQLException {
        T t = this.get(rs, index, dbSqlType);
        return this.prepareGetValue(t, destinationType);
    }

    protected <E> E prepareGetValue(T t, Class<E> destinationType) {
        if (t == null) {
            return null;
        }
        if (destinationType == null) {
            return (E)t;
        }
        return TypeConverterManager.convertType(t, destinationType);
    }
}

