/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.db.oom.sqlgen.chunks.SqlChunk;

public class TableChunk
extends SqlChunk {
    protected final Class entity;
    protected final String entityName;
    protected final String tableAlias;
    protected final String tableReference;
    protected DbEntityDescriptor ded;

    public TableChunk(Object entity) {
        super(2);
        this.entity = TableChunk.resolveClass(entity);
        this.entityName = null;
        this.tableAlias = this.entity.getSimpleName();
        this.tableReference = null;
    }

    public TableChunk(Object entity, String alias) {
        super(2);
        this.entity = TableChunk.resolveClass(entity);
        this.entityName = null;
        this.tableAlias = alias;
        this.tableReference = null;
    }

    public TableChunk(Object entity, String alias, String tableReference) {
        super(2);
        this.entity = TableChunk.resolveClass(entity);
        this.entityName = null;
        this.tableAlias = alias;
        this.tableReference = tableReference;
    }

    public TableChunk(String entityName, String alias) {
        this(null, entityName, alias, null);
    }

    protected TableChunk(Class entity, String entityName, String tableAlias, String tableReference) {
        super(2);
        this.entity = entity;
        this.entityName = entityName;
        this.tableAlias = tableAlias;
        this.tableReference = tableReference;
    }

    public TableChunk(String tableRef) {
        super(2);
        tableRef = tableRef.trim();
        int spaceNdx = tableRef.indexOf(32);
        this.entity = null;
        if (spaceNdx != -1) {
            this.entityName = tableRef.substring(0, spaceNdx);
            String alias = tableRef.substring(spaceNdx + 1).trim();
            this.tableAlias = alias.length() == 0 ? null : alias;
        } else {
            this.entityName = tableRef;
            this.tableAlias = null;
        }
        this.tableReference = null;
    }

    public void init(TemplateData templateData) {
        Object object;
        super.init(templateData);
        this.ded = this.entity != null ? this.lookupType(this.entity) : ((object = templateData.getObjectReference(this.entityName)) != null ? this.lookupType(TableChunk.resolveClass(object)) : this.lookupName(this.entityName));
        String tableReference = this.tableReference;
        if (tableReference == null) {
            tableReference = this.tableAlias;
        }
        if (tableReference == null) {
            tableReference = this.entityName;
        }
        if (tableReference == null) {
            tableReference = this.ded.getEntityName();
        }
        templateData.registerTableReference(tableReference, this.ded, this.tableAlias);
    }

    public void process(StringBuilder out) {
        this.separateByCommaOrSpace(out);
        out.append(this.ded.getTableName());
        if (this.tableAlias != null) {
            out.append(' ').append(this.tableAlias);
        }
    }
}

