/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen;

import jodd.bean.BeanUtil;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.util.StringUtil;

public class DbEntitySql {
    private static final String DELETE_FROM = "delete from ";
    private static final String WHERE = " where ";
    private static final String UPDATE = "update ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String SET = " set ";
    private static final String SELECT_COUNT_1_FROM = "select count(*) from ";

    public static DbSqlBuilder insert(Object entity) {
        return DbSqlBuilder.sql().insert(entity);
    }

    public static DbSqlBuilder truncate(Object entity) {
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null);
    }

    public static DbSqlBuilder update(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef).set(tableRef, entity)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef).setAll(tableRef, entity)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateColumn(Object entity, String columnRef, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, tableRef)._(SET).ref(null, columnRef)._("=").columnValue(value)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateColumn(Object entity, String columnRef) {
        Object value = BeanUtil.getProperty(entity, columnRef);
        return DbEntitySql.updateColumn(entity, columnRef, value);
    }

    public static DbSqlBuilder delete(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null, tableRef)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder deleteByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null, tableRef)._(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entity, null, tableRef)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entityType, long id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(DELETE_FROM).table(entityType, null, tableRef)._(WHERE).refId(tableRef)._("=").columnValue(id);
    }

    public static DbSqlBuilder from(Object entity) {
        return DbEntitySql.from(entity, DbEntitySql.createTableRefName(entity));
    }

    public static DbSqlBuilder from(Object entity, String tableRef) {
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(" ");
    }

    public static DbSqlBuilder from(Class entityType) {
        return DbEntitySql.from(entityType, DbEntitySql.createTableRefName(entityType));
    }

    public static DbSqlBuilder from(Class entityType, String tableRef) {
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entityType, tableRef)._(" ");
    }

    public static DbSqlBuilder find(Class target, Object matchEntity) {
        String tableRef = DbEntitySql.createTableRefName(target);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(target, tableRef)._(WHERE).match(tableRef, matchEntity);
    }

    public static DbSqlBuilder find(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder findByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder findByColumn(Class entity, String column, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).ref(tableRef, column)._("=").columnValue(value);
    }

    public static DbSqlBuilder findForeign(Class entity, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        DbOomManager dbOomManager = DbOomManager.getInstance();
        DbEntityDescriptor<?> dedFk = dbOomManager.lookupType(value.getClass());
        String tableName = dbOomManager.getTableNames().convertTableNameToEntityName(dedFk.getTableName());
        String columnName = dbOomManager.getColumnNames().convertColumnNameToPropertyName(dedFk.getIdColumnName());
        String fkColumn = StringUtil.uncapitalize(tableName) + StringUtil.capitalize(columnName);
        Object idValue = BeanUtil.getProperty(value, dedFk.getIdPropertyName());
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).ref(tableRef, fkColumn)._("=").columnValue(idValue);
    }

    public static DbSqlBuilder findById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entity, tableRef)._(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder findById(Object entityType, long id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(SELECT).column(tableRef)._(FROM).table(entityType, tableRef)._(WHERE).refId(tableRef)._("=").columnValue(id);
    }

    public static DbSqlBuilder count(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entity, tableRef)._(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder count(Class entityType) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entityType, tableRef);
    }

    public static DbSqlBuilder countAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(SELECT_COUNT_1_FROM).table(entity, tableRef)._(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder increaseColumn(Class entity, long id, String columnRef, Number delta, boolean increase) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql()._(UPDATE).table(entity, null, tableRef)._(SET).ref(null, columnRef)._("=").ref(null, columnRef)._(increase ? "+" : "-").columnValue(delta)._(WHERE).refId(tableRef)._("=").columnValue(id);
    }

    protected static String createTableRefName(Object entity) {
        Class type = entity.getClass();
        type = type == Class.class ? (Class)entity : type;
        return type.getSimpleName() + '_';
    }
}

