/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.bean.BeanUtilUtil;
import jodd.bean.JoddBean;
import jodd.introspector.Getter;
import jodd.introspector.Setter;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilBean
extends BeanUtilUtil {
    private static final char[] INDEX_CHARS = new char[]{'.', '['};

    protected void resolveNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.setName(name.substring(0, dotNdx));
            bp.setBean(this.getIndexProperty(bp));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.setName(name);
    }

    protected boolean resolveExistingNestedProperties(BeanProperty bp) {
        int dotNdx;
        String name = bp.name;
        while ((dotNdx = this.indexOfDot(name)) != -1) {
            bp.last = false;
            bp.setName(name.substring(0, dotNdx));
            String temp = bp.name;
            if (!this.hasIndexProperty(bp)) {
                return false;
            }
            bp.setName(temp);
            bp.setBean(this.getIndexProperty(bp));
            name = name.substring(dotNdx + 1);
        }
        bp.last = true;
        bp.setName(name);
        return true;
    }

    public boolean hasSimpleProperty(Object bean, String property, boolean declared) {
        return this.hasSimpleProperty(new BeanProperty(bean, property, declared, false));
    }

    protected boolean hasSimpleProperty(BeanProperty bp) {
        Map map;
        if (bp.bean == null) {
            return false;
        }
        Getter getter = bp.getGetter(bp.declared);
        if (getter != null) {
            return true;
        }
        return bp.isMap() && (map = (Map)bp.bean).containsKey(bp.name);
    }

    public Object getSimpleProperty(Object bean, String property, boolean declared) {
        return this.getSimpleProperty(new BeanProperty(bean, property, declared, false));
    }

    public Object getSimplePropertyForced(Object bean, String property, boolean declared) {
        return this.getSimpleProperty(new BeanProperty(bean, property, declared, true));
    }

    protected Object getSimpleProperty(BeanProperty bp) {
        if (bp.name.length() == 0 && bp.first || bp.name.equals(JoddBean.thisRef)) {
            return bp.bean;
        }
        Getter getter = bp.getGetter(bp.declared);
        if (getter != null) {
            Object result;
            try {
                result = getter.invokeGetter(bp.bean);
            }
            catch (Exception ex) {
                if (bp.silent) {
                    return null;
                }
                throw new BeanException("Getter failed: " + getter, ex);
            }
            if (result == null && bp.forced) {
                result = this.createBeanProperty(bp);
            }
            return result;
        }
        if (bp.isMap()) {
            Map map = (Map)bp.bean;
            Object key = this.convertIndexToMapKey(getter, bp.name);
            if (!map.containsKey(key)) {
                if (!bp.forced) {
                    if (bp.silent) {
                        return null;
                    }
                    throw new BeanException("Map key not found: " + bp.name, bp);
                }
                HashMap value = new HashMap();
                map.put(key, value);
                return value;
            }
            return map.get(key);
        }
        if (bp.silent) {
            return null;
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    public void setSimpleProperty(Object bean, String property, Object value, boolean declared) {
        this.setSimpleProperty(new BeanProperty(bean, property, declared, false), value);
    }

    protected void setSimpleProperty(BeanProperty bp, Object value) {
        Setter setter = bp.getSetter(bp.declared);
        if (setter != null) {
            this.invokeSetter(setter, bp, value);
            return;
        }
        if (bp.isMap()) {
            ((Map)bp.bean).put(bp.name, value);
            return;
        }
        if (bp.silent) {
            return;
        }
        throw new BeanException("Simple property not found: " + bp.name, bp);
    }

    public boolean hasIndexProperty(Object bean, String property, boolean declared) {
        return this.hasIndexProperty(new BeanProperty(bean, property, declared, false));
    }

    protected boolean hasIndexProperty(BeanProperty bp) {
        if (bp.bean == null) {
            return false;
        }
        String indexString = this.extractIndex(bp);
        if (indexString == null) {
            return this.hasSimpleProperty(bp);
        }
        Object resultBean = this.getSimpleProperty(bp);
        if (resultBean == null) {
            return false;
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < Array.getLength(resultBean);
        }
        if (resultBean instanceof List) {
            int index = this.parseInt(indexString, bp);
            return index >= 0 && index < ((List)resultBean).size();
        }
        if (resultBean instanceof Map) {
            return ((Map)resultBean).containsKey(indexString);
        }
        return false;
    }

    public Object getIndexProperty(Object bean, String property, boolean declared, boolean forced) {
        return this.getIndexProperty(new BeanProperty(bean, property, declared, forced));
    }

    protected Object getIndexProperty(BeanProperty bp) {
        String indexString = this.extractIndex(bp);
        Object resultBean = this.getSimpleProperty(bp);
        Getter getter = bp.getGetter(bp.declared);
        if (indexString == null) {
            return resultBean;
        }
        if (resultBean == null) {
            if (bp.silent) {
                return null;
            }
            throw new BeanException("Index property is null: " + bp.name, bp);
        }
        if (resultBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            if (bp.forced) {
                return this.arrayForcedGet(bp, resultBean, index);
            }
            return Array.get(resultBean, index);
        }
        if (resultBean instanceof List) {
            Object value;
            int index = this.parseInt(indexString, bp);
            List list = (List)resultBean;
            if (!bp.forced) {
                return list.get(index);
            }
            if (!bp.last) {
                this.ensureListSize(list, index);
            }
            if ((value = list.get(index)) == null) {
                Class<Map> listComponentType = this.extractGenericComponentType(getter);
                if (listComponentType == Object.class) {
                    listComponentType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(listComponentType);
                }
                catch (Exception ex) {
                    if (bp.silent) {
                        return null;
                    }
                    throw new BeanException("Invalid list element: " + bp.name + '[' + index + ']', bp, ex);
                }
                list.set(index, value);
            }
            return value;
        }
        if (resultBean instanceof Map) {
            Map map = (Map)resultBean;
            Object key = this.convertIndexToMapKey(getter, indexString);
            if (!bp.forced) {
                return map.get(key);
            }
            Object value = map.get(key);
            if (!bp.last && value == null) {
                Class<Map> mapComponentType = this.extractGenericComponentType(getter);
                if (mapComponentType == Object.class) {
                    mapComponentType = Map.class;
                }
                try {
                    value = ReflectUtil.newInstance(mapComponentType);
                }
                catch (Exception ex) {
                    if (bp.silent) {
                        return null;
                    }
                    throw new BeanException("Invalid map element: " + bp.name + '[' + indexString + ']', bp, ex);
                }
                map.put(key, value);
            }
            return value;
        }
        if (bp.silent) {
            return null;
        }
        throw new BeanException("Index property is not an array, list or map: " + bp.name, bp);
    }

    public void setIndexProperty(Object bean, String property, Object value, boolean declared, boolean forced) {
        this.setIndexProperty(new BeanProperty(bean, property, declared, forced), value);
    }

    protected void setIndexProperty(BeanProperty bp, Object value) {
        String indexString = this.extractIndex(bp);
        if (indexString == null) {
            this.setSimpleProperty(bp, value);
            return;
        }
        Object nextBean = this.getSimpleProperty(bp);
        Getter getter = bp.getGetter(bp.declared);
        if (nextBean == null) {
            if (bp.silent) {
                return;
            }
            throw new BeanException("Index property is null:" + bp.name, bp);
        }
        if (nextBean.getClass().isArray()) {
            int index = this.parseInt(indexString, bp);
            if (bp.forced) {
                this.arrayForcedSet(bp, nextBean, index, value);
            } else {
                Array.set(nextBean, index, value);
            }
            return;
        }
        if (nextBean instanceof List) {
            int index = this.parseInt(indexString, bp);
            Class listComponentType = this.extractGenericComponentType(getter);
            if (listComponentType != Object.class) {
                value = this.convertType(value, listComponentType);
            }
            List list = (List)nextBean;
            if (bp.forced) {
                this.ensureListSize(list, index);
            }
            list.set(index, value);
            return;
        }
        if (nextBean instanceof Map) {
            Map map = (Map)nextBean;
            Object key = this.convertIndexToMapKey(getter, indexString);
            Class mapComponentType = this.extractGenericComponentType(getter);
            if (mapComponentType != Object.class) {
                value = this.convertType(value, mapComponentType);
            }
            map.put(key, value);
            return;
        }
        if (bp.silent) {
            return;
        }
        throw new BeanException("Index property is not an array, list or map: " + bp.name, bp);
    }

    public void setProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value);
    }

    public void setPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void setPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, true);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value);
    }

    public void setPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, true, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void setDeclaredProperty(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value);
    }

    public void setDeclaredPropertySilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void setDeclaredPropertyForced(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, true);
        this.resolveNestedProperties(beanProperty);
        this.setIndexProperty(beanProperty, value);
    }

    public void setDeclaredPropertyForcedSilent(Object bean, String name, Object value) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, true, true);
        try {
            this.resolveNestedProperties(beanProperty);
            this.setIndexProperty(beanProperty, value);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public Object getProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false);
        this.resolveNestedProperties(beanProperty);
        return this.getIndexProperty(beanProperty);
    }

    public Object getPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false, true);
        try {
            this.resolveNestedProperties(beanProperty);
            return this.getIndexProperty(beanProperty);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Object getDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false);
        this.resolveNestedProperties(beanProperty);
        return this.getIndexProperty(beanProperty);
    }

    public Object getDeclaredPropertySilently(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false, true);
        try {
            this.resolveNestedProperties(beanProperty);
            return this.getIndexProperty(beanProperty);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public boolean hasProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return this.hasIndexProperty(beanProperty);
    }

    public boolean hasRootProperty(Object bean, String name) {
        int dotNdx = this.indexOfDot(name);
        if (dotNdx != -1) {
            name = name.substring(0, dotNdx);
        }
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false);
        this.extractIndex(beanProperty);
        return this.hasSimpleProperty(beanProperty);
    }

    public boolean hasDeclaredProperty(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return false;
        }
        return this.hasIndexProperty(beanProperty);
    }

    public boolean hasDeclaredRootProperty(Object bean, String name) {
        int dotNdx = this.indexOfDot(name);
        if (dotNdx != -1) {
            name = name.substring(0, dotNdx);
        }
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false);
        this.extractIndex(beanProperty);
        return this.hasSimpleProperty(beanProperty);
    }

    public Class getPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, false, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        this.hasIndexProperty(beanProperty);
        return this.extractType(beanProperty);
    }

    public Class getDeclaredPropertyType(Object bean, String name) {
        BeanProperty beanProperty = new BeanProperty(bean, name, true, false);
        if (!this.resolveExistingNestedProperties(beanProperty)) {
            return null;
        }
        this.hasIndexProperty(beanProperty);
        return this.extractType(beanProperty);
    }

    public void populateBean(Object bean, Map<?, ?> map) {
        this.populateProperty(bean, null, map);
    }

    public void populateProperty(Object bean, String name, Map<?, ?> map) {
        if (name != null) {
            if (map == null) {
                this.setSimpleProperty(bean, name, null, false);
                return;
            }
            bean = this.getSimplePropertyForced(bean, name, true);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value != null) {
                if (value instanceof Map) {
                    this.populateProperty(bean, key, (Map)value);
                    continue;
                }
                if (value instanceof List) {
                    this.populateProperty(bean, key, (List)value);
                    continue;
                }
            }
            this.setSimpleProperty(bean, key, value, true);
        }
    }

    public void populateProperty(Object bean, String name, List<?> list) {
        if (list == null) {
            this.setSimpleProperty(bean, name, null, false);
            return;
        }
        name = name + '[';
        int index = 0;
        for (Object item : list) {
            this.setIndexProperty(bean, name + index + ']', item, true, true);
            ++index;
        }
    }

    public String extractThisReference(String propertyName) {
        int ndx = StringUtil.indexOfChars(propertyName, INDEX_CHARS);
        if (ndx == -1) {
            return propertyName;
        }
        return propertyName.substring(0, ndx);
    }
}

